/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.IElementNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorMatchingContext;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementNameProcessorMatcher
implements IElementNameProcessorMatcher {
    private final String elementName;
    private final Map<String, String> attributeValuesByNameFilter;

    public ElementNameProcessorMatcher(String elementName) {
        this(elementName, null);
    }

    public ElementNameProcessorMatcher(String elementName, String filterAttributeName, String filterAttributeValue) {
        this(elementName, Collections.singletonMap(filterAttributeName, filterAttributeValue));
    }

    public ElementNameProcessorMatcher(String elementName, Map<String, String> attributeValuesByNameFilter) {
        Validate.notEmpty(elementName, "Element name cannot be null or empty");
        this.elementName = elementName;
        if (attributeValuesByNameFilter == null || attributeValuesByNameFilter.size() == 0) {
            this.attributeValuesByNameFilter = null;
        } else {
            HashMap<String, String> newAttributeValuesByNameFilter = new HashMap<String, String>(attributeValuesByNameFilter.size() + 1, 1.0f);
            newAttributeValuesByNameFilter.putAll(attributeValuesByNameFilter);
            this.attributeValuesByNameFilter = Collections.unmodifiableMap(newAttributeValuesByNameFilter);
        }
    }

    @Override
    public String getElementName(ProcessorMatchingContext context) {
        return Node.applyDialectPrefix(this.elementName, context.getDialectPrefix());
    }

    public Map<String, String> getAttributeValuesByNameFilter() {
        return this.attributeValuesByNameFilter;
    }

    public boolean hasFilter() {
        return this.attributeValuesByNameFilter != null;
    }

    @Override
    public boolean matches(Node node, ProcessorMatchingContext context) {
        if (!(node instanceof Element)) {
            return false;
        }
        Element element = (Element)node;
        String completeElementName = this.getElementName(context);
        if (!element.getNormalizedName().equals(completeElementName)) {
            return false;
        }
        if (this.attributeValuesByNameFilter != null) {
            for (Map.Entry<String, String> filterAttributeEntry : this.attributeValuesByNameFilter.entrySet()) {
                String elementAttributeValue;
                String filterAttributeName = filterAttributeEntry.getKey();
                String filterAttributeValue = filterAttributeEntry.getValue();
                if (!(!element.hasAttribute(filterAttributeName) ? filterAttributeValue != null : ((elementAttributeValue = element.getAttributeValue(filterAttributeName)) == null ? filterAttributeValue != null : !elementAttributeValue.equals(filterAttributeValue)))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final Class<? extends Element> appliesTo() {
        return Element.class;
    }
}

