/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.ComplexExpression;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;
import org.thymeleaf.standard.expression.SimpleExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression
implements Serializable {
    private static final long serialVersionUID = 1608378943284014151L;
    static final char PARSING_PLACEHOLDER_CHAR = '\u00a7';
    static final char NESTING_START_CHAR = '(';
    static final char NESTING_END_CHAR = ')';

    protected Expression() {
    }

    public abstract String getStringRepresentation();

    public String toString() {
        return this.getStringRepresentation();
    }

    static Expression parse(String input) {
        ExpressionParsingNode rootNode;
        if (input == null || input.trim().equals("")) {
            return null;
        }
        List<ExpressionParsingNode> decomposition = SimpleExpression.decomposeSimpleExpressions(input);
        if (decomposition == null) {
            return null;
        }
        if (!decomposition.get(0).isExpression()) {
            if ((decomposition = Expression.unnest(decomposition, 0)) == null) {
                return null;
            }
            if (!decomposition.get(0).isExpression() && (decomposition = ComplexExpression.composeComplexExpressions(decomposition, 0)) == null) {
                return null;
            }
        }
        if ((rootNode = decomposition.get(0)) == null || !rootNode.isExpression()) {
            return null;
        }
        return rootNode.getExpression();
    }

    static List<ExpressionParsingNode> unnest(List<ExpressionParsingNode> inputExprs, int inputIndex) {
        if (inputExprs == null || inputExprs.size() == 0 || inputIndex >= inputExprs.size()) {
            return null;
        }
        String input = inputExprs.get(inputIndex).getInput();
        StringBuilder inputWithPlaceholders = new StringBuilder();
        StringBuilder fragment = new StringBuilder();
        ArrayList<ExpressionParsingNode> fragments = new ArrayList<ExpressionParsingNode>();
        int currentIndex = inputExprs.size();
        ArrayList<Integer> nestedInputs = new ArrayList<Integer>();
        int parLevel = 0;
        int inputLen = input.length();
        for (int i = 0; i < inputLen; ++i) {
            char c = input.charAt(i);
            if (c == '(') {
                if (parLevel == 0) {
                    inputWithPlaceholders.append((CharSequence)fragment);
                    fragment = new StringBuilder();
                } else {
                    fragment.append(c);
                }
                ++parLevel;
                continue;
            }
            if (c == ')') {
                if (--parLevel < 0) {
                    return null;
                }
                if (parLevel == 0) {
                    int nestedIndex = currentIndex++;
                    nestedInputs.add(nestedIndex);
                    inputWithPlaceholders.append('\u00a7');
                    inputWithPlaceholders.append(String.valueOf(nestedIndex));
                    inputWithPlaceholders.append('\u00a7');
                    fragments.add(new ExpressionParsingNode(fragment.toString()));
                    fragment = new StringBuilder();
                    continue;
                }
                fragment.append(c);
                continue;
            }
            fragment.append(c);
        }
        if (parLevel > 0) {
            return null;
        }
        inputWithPlaceholders.append((CharSequence)fragment);
        List<ExpressionParsingNode> result = inputExprs;
        result.set(inputIndex, new ExpressionParsingNode(inputWithPlaceholders.toString()));
        result.addAll(fragments);
        for (Integer nestedInput : nestedInputs) {
            result = Expression.unnest(result, nestedInput);
        }
        return result;
    }

    static int placeHolderToIndex(String placeholder) {
        String str = placeholder.trim();
        int len = str.length();
        if (len <= 2) {
            return -1;
        }
        if (str.charAt(0) != '\u00a7' || str.charAt(len - 1) != '\u00a7') {
            return -1;
        }
        for (int i = 1; i < len - 1; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return -1;
        }
        return Integer.parseInt(str.substring(1, len - 1));
    }

    static Object execute(Arguments arguments, Expression expression, IStandardExpressionEvaluator expressionEvaluator) {
        if (expression instanceof SimpleExpression) {
            return SimpleExpression.executeSimple(arguments, (SimpleExpression)expression, expressionEvaluator);
        }
        if (expression instanceof ComplexExpression) {
            return ComplexExpression.executeComplex(arguments, (ComplexExpression)expression, expressionEvaluator);
        }
        throw new TemplateProcessingException("Unrecognized expression: " + expression.getClass().getName());
    }
}

