/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionSequence;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.standard.expression.TextLiteralExpression;
import org.thymeleaf.standard.expression.Token;
import org.thymeleaf.util.MessageResolutionUtils;
import org.thymeleaf.util.Validate;

public final class MessageExpression
extends SimpleExpression {
    private static final Logger logger = LoggerFactory.getLogger(MessageExpression.class);
    private static final long serialVersionUID = 8394399541792390735L;
    static final char SELECTOR = '#';
    private static final char PARAMS_START_CHAR = '(';
    private static final char PARAMS_END_CHAR = ')';
    private static final Pattern MSG_PATTERN = Pattern.compile("^\\s*\\#\\{(.+?)\\}\\s*$", 32);
    private final Expression base;
    private final ExpressionSequence parameters;

    public MessageExpression(Expression base, ExpressionSequence parameters) {
        Validate.notNull(base, "Base cannot be null");
        this.base = base;
        this.parameters = parameters;
    }

    public Expression getBase() {
        return this.base;
    }

    public ExpressionSequence getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.size() > 0;
    }

    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append('#');
        sb.append('{');
        sb.append(this.base);
        if (this.hasParameters()) {
            sb.append('(');
            sb.append(this.parameters.getStringRepresentation());
            sb.append(')');
        }
        sb.append('}');
        return sb.toString();
    }

    static MessageExpression parseMessage(String input) {
        Matcher matcher = MSG_PATTERN.matcher(input);
        if (!matcher.matches()) {
            return null;
        }
        String content = matcher.group(1);
        if (content == null || content.trim().equals("")) {
            return null;
        }
        String trimmedInput = content.trim();
        if (trimmedInput.endsWith(String.valueOf(')'))) {
            boolean inLiteral = false;
            int nestParLevel = 0;
            for (int i = trimmedInput.length() - 1; i >= 0; --i) {
                char c = trimmedInput.charAt(i);
                if (c == '\'') {
                    if (i != 0 && content.charAt(i - 1) == '\\') continue;
                    inLiteral = !inLiteral;
                    continue;
                }
                if (c == ')') {
                    ++nestParLevel;
                    continue;
                }
                if (c != '(') continue;
                if (--nestParLevel < 0) {
                    return null;
                }
                if (nestParLevel != 0) continue;
                if (i == 0) {
                    return null;
                }
                String base = trimmedInput.substring(0, i);
                String parameters = trimmedInput.substring(i + 1, trimmedInput.length() - 1);
                Expression baseExpr = MessageExpression.computeBase(base);
                if (baseExpr == null) {
                    return null;
                }
                ExpressionSequence parametersExprSeq = ExpressionSequence.parse(parameters);
                if (parametersExprSeq == null) {
                    return null;
                }
                return new MessageExpression(baseExpr, parametersExprSeq);
            }
            return null;
        }
        Expression baseExpr = MessageExpression.computeBase(trimmedInput);
        if (baseExpr == null) {
            return null;
        }
        return new MessageExpression(baseExpr, null);
    }

    private static Expression computeBase(String baseStr) {
        Token token = Token.parse(baseStr);
        if (token != null) {
            return TextLiteralExpression.parseTextLiteral(token.getValue());
        }
        return Expression.parse(baseStr);
    }

    static Object executeMessage(Arguments arguments, MessageExpression expression, IStandardExpressionEvaluator expressionEvaluator) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating message: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        Expression baseExpression = expression.getBase();
        Object messageKey = Expression.execute(arguments, baseExpression, expressionEvaluator);
        if ((messageKey = LiteralValue.unwrap(messageKey)) != null && !(messageKey instanceof String)) {
            messageKey = messageKey.toString();
        }
        if (messageKey == null || ((String)messageKey).trim().equals("")) {
            throw new TemplateProcessingException("Message key for message resolution must be a non-null and non-empty String");
        }
        Object[] messageParameters = new Object[expression.hasParameters() ? expression.getParameters().size() : 0];
        int parIndex = 0;
        if (expression.hasParameters()) {
            for (Expression parameter : expression.getParameters()) {
                Object result = Expression.execute(arguments, parameter, expressionEvaluator);
                messageParameters[parIndex++] = LiteralValue.unwrap(result);
            }
        }
        return MessageResolutionUtils.resolveMessageForTemplate(arguments, (String)messageKey, messageParameters);
    }
}

