/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.Collections;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OgnlExpressionEvaluator
implements IStandardExpressionEvaluator {
    public static final OgnlExpressionEvaluator INSTANCE = new OgnlExpressionEvaluator();
    private static final String OGNL_CACHE_PREFIX = "{ognl}";
    private static final Logger logger = LoggerFactory.getLogger(OgnlExpressionEvaluator.class);

    @Override
    public final Object evaluate(Arguments arguments, String expression, Object root) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] OGNL expression: evaluating expression \"{}\" on target", (Object)TemplateEngine.threadIndex(), (Object)expression);
            }
            Object expressionTree = null;
            ICache<String, Object> cache = null;
            ICacheManager cacheManager = arguments.getConfiguration().getCacheManager();
            if (cacheManager != null && (cache = cacheManager.getExpressionCache()) != null) {
                expressionTree = cache.get(OGNL_CACHE_PREFIX + expression);
            }
            if (expressionTree == null) {
                expressionTree = Ognl.parseExpression((String)expression);
                if (cache != null && null != expressionTree) {
                    cache.put(OGNL_CACHE_PREFIX + expression, expressionTree);
                }
            }
            Map<String, Object> contextVariables = arguments.getBaseContextVariables();
            Map<String, Object> additionalContextVariables = this.computeAdditionalContextVariables(arguments);
            if (additionalContextVariables != null && !additionalContextVariables.isEmpty()) {
                contextVariables.putAll(additionalContextVariables);
            }
            return Ognl.getValue((Object)expressionTree, contextVariables, (Object)root);
        }
        catch (OgnlException e) {
            throw new TemplateProcessingException("Exception evaluating OGNL expression: \"" + expression + "\"", e);
        }
    }

    protected Map<String, Object> computeAdditionalContextVariables(Arguments arguments) {
        return Collections.emptyMap();
    }

    private OgnlExpressionEvaluator() {
    }

    public String toString() {
        return "OGNL";
    }
}

