/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateOutputException;
import org.thymeleaf.templatewriter.XhtmlHtml5TemplateWriter;
import org.thymeleaf.templatewriter.XmlTemplateWriter;
import org.thymeleaf.util.Validate;

public final class DOMUtils {
    private static final char[] AMP = "&amp;".toCharArray();
    private static final char[] LT = "&lt;".toCharArray();
    private static final char[] GT = "&gt;".toCharArray();
    private static final char[] QUOT = "&quot;".toCharArray();
    private static final char[] APOS = "&#39;".toCharArray();

    public static NestableNode extractFragmentByAttributeValue(Node root, String elementName, String attributeName, String attributeValue) {
        Validate.notNull(root, "Root cannot be null");
        Validate.notNull(attributeName, "Attribute name cannot be null");
        Validate.notNull(attributeValue, "Attribute value cannot be null");
        return DOMUtils.exploreNodeForExtractingFragment(root, Node.normalizeName(elementName), Node.normalizeName(attributeName), attributeValue);
    }

    private static NestableNode exploreNodeForExtractingFragment(Node node, String normalizedElementName, String normalizedAttributeName, String attributeValue) {
        if (node instanceof NestableNode) {
            String elementAttrValue;
            Element element;
            NestableNode nestableNode = (NestableNode)node;
            if (nestableNode instanceof Element && (element = (Element)nestableNode).hasNormalizedAttribute(normalizedAttributeName) && (normalizedElementName == null || normalizedElementName.equals(element.getNormalizedName())) && (elementAttrValue = element.getAttributeValue(normalizedAttributeName)) != null && elementAttrValue.trim().equals(attributeValue)) {
                return nestableNode;
            }
            List<Node> children = nestableNode.getChildren();
            for (Node child : children) {
                NestableNode childResult = DOMUtils.exploreNodeForExtractingFragment(child, normalizedElementName, normalizedAttributeName, attributeValue);
                if (childResult == null) continue;
                return childResult;
            }
        }
        return null;
    }

    public static char[] escapeXml(char[] ch, boolean escapeQuotes) throws IOException {
        if (ch == null) {
            return null;
        }
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (c != '&' && c != '<' && c != '>' && (!escapeQuotes || c != '\'' && c != '\"')) continue;
            CharArrayWriter writer = new CharArrayWriter();
            DOMUtils.writeXmlEscaped(ch, (Writer)writer, escapeQuotes);
            return writer.toCharArray();
        }
        return ch;
    }

    public static String escapeXml(String str, boolean escapeQuotes) throws IOException {
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (c != '&' && c != '<' && c != '>' && (!escapeQuotes || c != '\'' && c != '\"')) continue;
            CharArrayWriter writer = new CharArrayWriter();
            DOMUtils.writeXmlEscaped(str, (Writer)writer, escapeQuotes);
            return writer.toString();
        }
        return str;
    }

    public static void writeXmlEscaped(String buffer, Writer writer, boolean escapeQuotes) throws IOException {
        if (buffer == null) {
            return;
        }
        DOMUtils.writeXmlEscaped(buffer.toCharArray(), writer, escapeQuotes);
    }

    public static void writeXmlEscaped(char[] buffer, Writer writer, boolean escapeQuotes) throws IOException {
        if (buffer == null || buffer.length == 0) {
            return;
        }
        int off = 0;
        int len = 0;
        for (int i = 0; i < buffer.length; ++i) {
            char c = buffer[i];
            if (c == '&') {
                if (len > 0) {
                    writer.write(buffer, off, len);
                }
                writer.write(AMP);
                off = i + 1;
                len = 0;
                continue;
            }
            if (c == '<') {
                if (len > 0) {
                    writer.write(buffer, off, len);
                }
                writer.write(LT);
                off = i + 1;
                len = 0;
                continue;
            }
            if (c == '>') {
                if (len > 0) {
                    writer.write(buffer, off, len);
                }
                writer.write(GT);
                off = i + 1;
                len = 0;
                continue;
            }
            if (escapeQuotes && c == '\"') {
                if (len > 0) {
                    writer.write(buffer, off, len);
                }
                writer.write(QUOT);
                off = i + 1;
                len = 0;
                continue;
            }
            if (escapeQuotes && c == '\'') {
                if (len > 0) {
                    writer.write(buffer, off, len);
                }
                writer.write(APOS);
                off = i + 1;
                len = 0;
                continue;
            }
            ++len;
        }
        if (len > 0) {
            writer.write(buffer, off, len);
        }
    }

    public static String unescapeXml(String str, boolean unescapeQuotes) {
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        boolean existsAmpersand = false;
        for (int i = 0; i < strLen; ++i) {
            if (str.charAt(i) != '&') continue;
            existsAmpersand = true;
            break;
        }
        if (!existsAmpersand) {
            return str;
        }
        int off = 0;
        int len = 0;
        int entityStart = -1;
        int entityLen = 0;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (c == '&') {
                if (entityLen > 0) {
                    builder.append(str.substring(entityStart, entityStart + entityLen));
                } else if (len > 0) {
                    builder.append(str.substring(off, off + len));
                }
                entityStart = i;
                entityLen = 1;
                off = -1;
                len = 0;
                continue;
            }
            if (c == ';' && entityStart != -1) {
                builder.append(DOMUtils.unescapeXmlEntity(str, entityStart, entityLen + 1, unescapeQuotes));
                entityStart = -1;
                entityLen = 0;
                off = i + 1;
                len = 0;
                continue;
            }
            if (entityStart != -1) {
                ++entityLen;
                continue;
            }
            ++len;
        }
        if (entityLen > 0) {
            builder.append(str, entityStart, entityStart + entityLen);
        } else if (len > 0) {
            builder.append(str.substring(off, off + len));
        }
        return builder.toString();
    }

    private static String unescapeXmlEntity(String str, int off, int len, boolean unescapeQuotes) {
        if (len < 4) {
            return str.substring(off, off + len);
        }
        char c1 = str.charAt(off + 1);
        char c2 = str.charAt(off + 2);
        if (len == 4 && c1 == 'l' && c2 == 't') {
            return "<";
        }
        if (len == 4 && c1 == 'g' && c2 == 't') {
            return ">";
        }
        if (len == 5 && c1 == 'a' && c2 == 'm' && str.charAt(off + 3) == 'p') {
            return "&";
        }
        if (len == 6 && unescapeQuotes && c1 == 'q' && c2 == 'u' && str.charAt(off + 3) == 'o' && str.charAt(off + 4) == 't') {
            return "\"";
        }
        if (len == 6 && unescapeQuotes && c1 == 'a' && c2 == 'p' && str.charAt(off + 3) == 'o' && str.charAt(off + 4) == 's') {
            return "'";
        }
        if (len == 5 && c1 == '#') {
            char c3 = str.charAt(off + 3);
            if (c2 == '6' && c3 == '0') {
                return "<";
            }
            if (c2 == '6' && c3 == '2') {
                return ">";
            }
            if (c2 == '3' && c3 == '8') {
                return "&";
            }
            if (unescapeQuotes && c2 == '3' && c3 == '4') {
                return "\"";
            }
            if (unescapeQuotes && c2 == '3' && c3 == '9') {
                return "'";
            }
        }
        return str.substring(off, off + len);
    }

    public static String getXmlFor(Node node) {
        try {
            XmlTemplateWriter templateWriter = new XmlTemplateWriter();
            StringWriter writer = new StringWriter();
            templateWriter.writeNode(null, writer, node);
            return writer.toString();
        }
        catch (IOException e) {
            throw new TemplateOutputException("Exception during creation of XML output for node", e);
        }
    }

    public static String getXhtmlHtml5For(Node node) {
        try {
            XhtmlHtml5TemplateWriter templateWriter = new XhtmlHtml5TemplateWriter();
            StringWriter writer = new StringWriter();
            templateWriter.writeNode(null, writer, node);
            return writer.toString();
        }
        catch (IOException e) {
            throw new TemplateOutputException("Exception during creation of XHTML/HTML5 output for node", e);
        }
    }

    private DOMUtils() {
    }
}

