/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.io.Serializable;
import org.thymeleaf.util.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdentityCounter<T>
implements Serializable {
    private static final long serialVersionUID = -6787140331913313991L;
    private Object[] counted;
    private int countedSize;
    private int countedLen;

    public IdentityCounter(int expectedMaxSize) {
        this.counted = new Object[expectedMaxSize];
        this.countedSize = expectedMaxSize;
        this.countedLen = 0;
    }

    public void count(T object) {
        if (this.countedLen >= this.countedSize) {
            this.countedSize *= 2;
            this.counted = ArrayUtils.copyOf(this.counted, this.countedSize);
        }
        this.counted[this.countedLen++] = object;
    }

    public boolean isAlreadyCounted(T object) {
        for (int i = 0; i < this.countedLen; ++i) {
            if (this.counted[i] != object) continue;
            return true;
        }
        return false;
    }
}

