/*
 * Decompiled with CFR 0.152.
 */
package play.modules.thymeleaf.adapter;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import play.mvc.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionAdapter
implements Map<String, String> {
    private Scope.Session session = Scope.Session.current();
    private Map<String, String> dataMap;

    @Override
    public void clear() {
        this.session.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.session.contains((String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getDataMap().containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.getDataMap().entrySet();
    }

    @Override
    public String get(Object key) {
        return this.session.get((String)key);
    }

    @Override
    public boolean isEmpty() {
        return this.getDataMap().isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.getDataMap().keySet();
    }

    @Override
    public String put(String key, String value) {
        String prev = this.session.get(key);
        this.session.put(key, value);
        return prev;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        Set<Map.Entry<? extends String, ? extends String>> set = m.entrySet();
        Iterator<Map.Entry<? extends String, ? extends String>> i$ = set.iterator();
        while (i$.hasNext()) {
            Map.Entry<? extends String, ? extends String> object;
            Map.Entry<? extends String, ? extends String> entry = object = i$.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String remove(Object key) {
        String prev = this.session.get((String)key);
        this.session.remove((String)key);
        return prev;
    }

    @Override
    public int size() {
        return this.getDataMap().size();
    }

    @Override
    public Collection<String> values() {
        return this.getDataMap().values();
    }

    private Map<String, String> getDataMap() {
        if (this.dataMap == null) {
            try {
                Field mapField = this.session.getClass().getDeclaredField("data");
                mapField.setAccessible(true);
                this.dataMap = (Map)mapField.get(this.session);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.dataMap;
    }

    public String getAuthenticityToken() {
        return this.session.getAuthenticityToken();
    }
}

