/*
 * Decompiled with CFR 0.152.
 */
package play.modules.thymeleaf.dialect;

import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;
import org.thymeleaf.processor.attr.AbstractSingleAttributeModifierAttrProcessor;
import org.thymeleaf.util.PrefixUtils;
import play.modules.thymeleaf.dialect.ProcessorUtil;

public class PlayActionAttributeModifierAttrProcessor
extends AbstractSingleAttributeModifierAttrProcessor {
    public static final Integer ATTR_PRECEDENCE = 1000;
    public static final String[] ATTR_NAMES = new String[]{"action", "href", "name", "src", "type", "value"};
    public static final PlayActionAttributeModifierAttrProcessor[] PROCESSORS = new PlayActionAttributeModifierAttrProcessor[ATTR_NAMES.length];

    private PlayActionAttributeModifierAttrProcessor(String attributeName) {
        super(attributeName);
    }

    public int getPrecedence() {
        return ATTR_PRECEDENCE;
    }

    protected String getTargetAttributeName(Arguments arguments, Element element, String attributeName) {
        return PrefixUtils.getUnprefixed((String)attributeName);
    }

    protected AbstractAttributeModifierAttrProcessor.ModificationType getModificationType(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return AbstractAttributeModifierAttrProcessor.ModificationType.SUBSTITUTION;
    }

    protected boolean removeAttributeIfEmpty(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return false;
    }

    protected boolean recomputeProcessorsAfterExecution(Arguments arguments, Element element, String attributeName) {
        return false;
    }

    protected String getTargetAttributeValue(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        return ProcessorUtil.toActionString(arguments, attributeValue);
    }

    static {
        for (int i = 0; i < PROCESSORS.length; ++i) {
            PlayActionAttributeModifierAttrProcessor.PROCESSORS[i] = new PlayActionAttributeModifierAttrProcessor(ATTR_NAMES[i]);
        }
    }
}

