/*
 * Decompiled with CFR 0.152.
 */
package play.modules.thymeleaf.dialect;

import java.util.Collections;
import java.util.Map;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import ognl.ClassResolver;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.ObjectUtils;
import play.modules.thymeleaf.dialect.PlayClassResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayOgnlExpressionEvaluator
implements IStandardExpressionEvaluator {
    public static final PlayOgnlExpressionEvaluator INSTANCE = new PlayOgnlExpressionEvaluator();
    private static final String OGNL_CACHE_PREFIX = "{ognl}";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static boolean booleanFixApplied = false;
    private PlayClassResolver classResolver = new PlayClassResolver();

    public void clearClassCache() {
        this.classResolver.clearClassCache();
    }

    public final Object evaluate(Arguments arguments, String expression, Object root) {
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[THYMELEAF][{}] OGNL expression: evaluating expression \"{}\" on target", (Object)TemplateEngine.threadIndex(), (Object)expression);
            }
            Object expressionTree = null;
            ICache cache = null;
            ICacheManager cacheManager = arguments.getConfiguration().getCacheManager();
            if (cacheManager != null && (cache = cacheManager.getExpressionCache()) != null) {
                expressionTree = cache.get((Object)(OGNL_CACHE_PREFIX + expression));
            }
            if (expressionTree == null) {
                expressionTree = Ognl.parseExpression((String)expression);
                if (cache != null && null != expressionTree) {
                    cache.put((Object)(OGNL_CACHE_PREFIX + expression), expressionTree);
                }
            }
            Map contextVariables = arguments.getBaseContextVariables();
            Map<String, Object> additionalContextVariables = this.computeAdditionalContextVariables(arguments);
            if (additionalContextVariables != null && !additionalContextVariables.isEmpty()) {
                contextVariables.putAll(additionalContextVariables);
            }
            OgnlContext context = new OgnlContext(contextVariables);
            context.setClassResolver((ClassResolver)this.classResolver);
            return Ognl.getValue((Object)expressionTree, (Map)context, (Object)root);
        }
        catch (OgnlException e) {
            throw new TemplateProcessingException("Exception evaluating OGNL expression: \"" + expression + "\"", (Throwable)e);
        }
    }

    protected Map<String, Object> computeAdditionalContextVariables(Arguments arguments) {
        return Collections.emptyMap();
    }

    private PlayOgnlExpressionEvaluator() {
        if (!booleanFixApplied && this.shouldApplyOgnlBooleanFix()) {
            this.applyOgnlBooleanFix();
            booleanFixApplied = true;
        }
    }

    public String toString() {
        return "OGNL";
    }

    protected boolean shouldApplyOgnlBooleanFix() {
        return true;
    }

    private void applyOgnlBooleanFix() {
        try {
            ClassLoader classLoader = ClassLoaderUtils.getClassLoader(PlayOgnlExpressionEvaluator.class);
            ClassPool pool = new ClassPool(true);
            pool.insertClassPath((ClassPath)new LoaderClassPath(classLoader));
            CtClass[] params = new CtClass[]{pool.get(Object.class.getName())};
            CtClass ognlClass = pool.get("ognl.OgnlOps");
            CtClass fixClass = pool.get(PlayOgnlExpressionEvaluator.class.getName());
            CtMethod ognlMethod = ognlClass.getDeclaredMethod("booleanValue", params);
            CtMethod fixMethod = fixClass.getDeclaredMethod("fixBooleanValue", params);
            ognlMethod.setBody(fixMethod, null);
            ognlClass.toClass(classLoader, null);
        }
        catch (Exception e) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Thymeleaf was not able to apply a fix on OGNL's boolean evaluation that would have enabled OGNL to evaluate Strings as booleans (e.g. in \"th:if\") in exactly the same way as Thymeleaf itself or Spring EL ('false', 'off' and 'no' should be considered \"false\"). This did not stop the initialization process.", (Throwable)e);
            }
            this.logger.info("Thymeleaf was not able to apply a fix on OGNL's boolean evaluation that would have enabled OGNL to evaluate Strings as booleans (e.g. in \"th:if\") in exactly the same way as Thymeleaf itself or Spring EL ('false', 'off' and 'no' should be considered \"false\"). This did not stop the initialization process. Exception raised was " + e.getClass().getName() + ": " + e.getMessage() + " [Set the log to TRACE for the complete exception stack trace]");
        }
    }

    static boolean fixBooleanValue(Object value) {
        return ObjectUtils.evaluateAsBoolean((Object)value);
    }
}

