/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.DialectConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.doctype.resolution.IDocTypeResolutionEntry;
import org.thymeleaf.doctype.translation.IDocTypeTranslation;
import org.thymeleaf.dom.Node;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.processor.ProcessorAndContext;
import org.thymeleaf.templatemode.ITemplateModeHandler;
import org.thymeleaf.templateresolver.ITemplateResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConfigurationPrinterHelper {
    public static final String CONFIGURATION_LOGGER_NAME = TemplateEngine.class.getName() + ".CONFIG";
    private static final Logger configLogger = LoggerFactory.getLogger((String)CONFIGURATION_LOGGER_NAME);

    static void printConfiguration(Set<DialectConfiguration> dialectConfigurations, Map<String, Boolean> lenienciesByPrefix, Set<ITemplateResolver> templateResolvers, Set<IMessageResolver> messageResolvers, ICacheManager cacheFactory, Set<ITemplateModeHandler> templateModeHandlers) {
        ConfigLogBuilder logBuilder = new ConfigLogBuilder();
        logBuilder.line("[THYMELEAF] TEMPLATE ENGINE CONFIGURATION:");
        logBuilder.line("[THYMELEAF] * Cache Factory implementation: {}", cacheFactory == null ? "[no caches]" : cacheFactory.getClass().getName());
        logBuilder.line("[THYMELEAF] * Template modes:");
        for (ITemplateModeHandler templateModeHandler : templateModeHandlers) {
            logBuilder.line("[THYMELEAF]     * {}", templateModeHandler.getTemplateModeName());
        }
        logBuilder.line("[THYMELEAF] * Template resolvers (in order):");
        for (ITemplateResolver templateResolver : templateResolvers) {
            if (templateResolver.getOrder() != null) {
                logBuilder.line("[THYMELEAF]     * [{}] {}", templateResolver.getOrder(), templateResolver.getName());
                continue;
            }
            logBuilder.line("[THYMELEAF]     * {}", templateResolver.getName());
        }
        logBuilder.line("[THYMELEAF] * Message resolvers (in order):");
        for (IMessageResolver messageResolver : messageResolvers) {
            if (messageResolver.getOrder() != null) {
                logBuilder.line("[THYMELEAF]     * [{}] {}", messageResolver.getOrder(), messageResolver.getName());
                continue;
            }
            logBuilder.line("[THYMELEAF]     * {}", messageResolver.getName());
        }
        int dialectIndex = 1;
        Integer totalDialects = dialectConfigurations.size();
        for (DialectConfiguration dialectConfiguration : dialectConfigurations) {
            IDialect dialect = dialectConfiguration.getDialect();
            if (totalDialects > 1) {
                logBuilder.line("[THYMELEAF] * Dialect [{} of {}]: {}", new Object[]{dialectIndex, totalDialects, dialect.getClass().getName()});
            } else {
                logBuilder.line("[THYMELEAF] * Dialect: {}", dialect.getClass().getName());
            }
            logBuilder.line("[THYMELEAF]     * Prefix: \"{}\"", dialectConfiguration.getPrefix() != null ? dialectConfiguration.getPrefix() : "(none)");
            if (configLogger.isDebugEnabled()) {
                ConfigurationPrinterHelper.printDebugConfiguration(logBuilder, dialectConfiguration);
            }
            ++dialectIndex;
        }
        if (totalDialects > 1) {
            logBuilder.line("[THYMELEAF] * Leniencies by prefix:");
            for (Map.Entry entry : lenienciesByPrefix.entrySet()) {
                logBuilder.line("[THYMELEAF]     * \"{}\": {}", entry.getKey(), (Boolean)entry.getValue() != false ? "LENIENT" : "NON-LENIENT");
            }
        }
        logBuilder.end("[THYMELEAF] TEMPLATE ENGINE CONFIGURED OK");
        if (configLogger.isDebugEnabled()) {
            configLogger.debug(logBuilder.toString());
        } else if (configLogger.isInfoEnabled()) {
            configLogger.info(logBuilder.toString());
        }
    }

    private static void printDebugConfiguration(ConfigLogBuilder logBuilder, DialectConfiguration dialectConfiguration) {
        String attrName;
        String precedence;
        Map<String, Set<ProcessorAndContext>> specificProcessorsByElementName = dialectConfiguration.unsafeGetSpecificProcessorsByElementName();
        Map<String, Set<ProcessorAndContext>> specificProcessorsByAttributeName = dialectConfiguration.unsafeGetSpecificProcessorsByAttributeName();
        Map<Class<? extends Node>, Set<ProcessorAndContext>> nonSpecificProcessorsByNodeClass = dialectConfiguration.unsafeGetNonSpecificProcessorsByNodeClass();
        Map<String, Object> executionAttributes = dialectConfiguration.getExecutionAttributes();
        boolean lenient = dialectConfiguration.isLenient();
        Set<IDocTypeResolutionEntry> docTypeResolutionEntries = dialectConfiguration.getDialect().getDocTypeResolutionEntries();
        Set<IDocTypeTranslation> docTypeTranslations = dialectConfiguration.getDialect().getDocTypeTranslations();
        LinkedHashMap<String, Set<ProcessorAndContext>> orderedSpecificProcessorsByElementName = new LinkedHashMap<String, Set<ProcessorAndContext>>();
        ArrayList<String> elementNames = new ArrayList<String>(specificProcessorsByElementName.keySet());
        Collections.sort(elementNames);
        for (String elementName : elementNames) {
            orderedSpecificProcessorsByElementName.put(elementName, specificProcessorsByElementName.get(elementName));
        }
        LinkedHashMap<String, Set<ProcessorAndContext>> orderedSpecificProcessorsByAttributeName = new LinkedHashMap<String, Set<ProcessorAndContext>>();
        ArrayList<String> attributeNames = new ArrayList<String>(specificProcessorsByAttributeName.keySet());
        Collections.sort(attributeNames);
        for (String string : attributeNames) {
            orderedSpecificProcessorsByAttributeName.put(string, specificProcessorsByAttributeName.get(string));
        }
        logBuilder.line("[THYMELEAF]     * Lenient: {}", lenient);
        if (!orderedSpecificProcessorsByElementName.isEmpty()) {
            logBuilder.line("[THYMELEAF]     * Processors matching nodes by element name [precedence]:");
            for (Map.Entry entry : orderedSpecificProcessorsByElementName.entrySet()) {
                String elementName = (String)entry.getKey();
                for (ProcessorAndContext elementProcessorEntry : (Set)entry.getValue()) {
                    IProcessor elementProcessor = elementProcessorEntry.getProcessor();
                    precedence = elementProcessor instanceof AbstractProcessor ? Integer.valueOf(((AbstractProcessor)elementProcessor).getPrecedence()).toString() : "-";
                    logBuilder.line("[THYMELEAF]         * \"{}\" [{}]: {}", new Object[]{elementName, precedence, elementProcessor.getClass().getName()});
                }
            }
        }
        if (!orderedSpecificProcessorsByAttributeName.isEmpty()) {
            logBuilder.line("[THYMELEAF]     * Processors matching nodes by element attribute [precedence]:");
            for (Map.Entry entry : orderedSpecificProcessorsByAttributeName.entrySet()) {
                attrName = (String)entry.getKey();
                for (ProcessorAndContext attrProcessorEntry : (Set)entry.getValue()) {
                    IProcessor attrProcessor = attrProcessorEntry.getProcessor();
                    precedence = attrProcessor instanceof AbstractProcessor ? Integer.valueOf(((AbstractProcessor)attrProcessor).getPrecedence()).toString() : "-";
                    logBuilder.line("[THYMELEAF]         * \"{}\" [{}]: {}", new Object[]{attrName, precedence, attrProcessor.getClass().getName()});
                }
            }
        }
        if (!nonSpecificProcessorsByNodeClass.isEmpty()) {
            logBuilder.line("[THYMELEAF]     * Processors with non-element-specific matching methods [precedence]:");
            for (Map.Entry entry : nonSpecificProcessorsByNodeClass.entrySet()) {
                Class nodeClass = (Class)entry.getKey();
                for (ProcessorAndContext processorEntry : (Set)entry.getValue()) {
                    IProcessor processor = processorEntry.getProcessor();
                    precedence = processor instanceof AbstractProcessor ? Integer.valueOf(((AbstractProcessor)processor).getPrecedence()).toString() : "-";
                    logBuilder.line("[THYMELEAF]         * [{}] [{}]: {}", new Object[]{nodeClass.getSimpleName(), precedence, processor.getClass().getName()});
                }
            }
        }
        if (!executionAttributes.isEmpty()) {
            logBuilder.line("[THYMELEAF]     * Execution Attributes:");
            for (Map.Entry entry : executionAttributes.entrySet()) {
                attrName = (String)entry.getKey();
                String attrValue = entry.getValue() == null ? null : entry.getValue().toString();
                logBuilder.line("[THYMELEAF]         * \"{}\": {}", new Object[]{attrName, attrValue});
            }
        }
        logBuilder.line("[THYMELEAF]     * DOCTYPE translations:");
        for (IDocTypeTranslation iDocTypeTranslation : docTypeTranslations) {
            logBuilder.line("[THYMELEAF]         * DOCTYPE Translation:");
            if (iDocTypeTranslation.getSourcePublicID().isNone()) {
                logBuilder.line("[THYMELEAF]             * Source: SYSTEM \"{}\"", new Object[]{iDocTypeTranslation.getSourceSystemID().isAny() ? "*" : iDocTypeTranslation.getSourceSystemID()});
            } else {
                logBuilder.line("[THYMELEAF]             * Source: PUBLIC \"{}\" \"{}\"", new Object[]{iDocTypeTranslation.getSourcePublicID().isAny() ? "*" : iDocTypeTranslation.getSourcePublicID(), iDocTypeTranslation.getSourceSystemID().isAny() ? "*" : iDocTypeTranslation.getSourceSystemID()});
            }
            if (iDocTypeTranslation.getTargetPublicID().isNone()) {
                logBuilder.line("[THYMELEAF]             * Target: SYSTEM \"{}\"", new Object[]{iDocTypeTranslation.getTargetSystemID().isAny() ? "*" : iDocTypeTranslation.getTargetSystemID()});
                continue;
            }
            logBuilder.line("[THYMELEAF]             * Target: PUBLIC \"{}\" \"{}\"", new Object[]{iDocTypeTranslation.getTargetPublicID().isAny() ? "*" : iDocTypeTranslation.getTargetPublicID(), iDocTypeTranslation.getTargetSystemID().isAny() ? "*" : iDocTypeTranslation.getTargetSystemID()});
        }
        logBuilder.line("[THYMELEAF]     * DOCTYPE resolution entries:");
        for (IDocTypeResolutionEntry iDocTypeResolutionEntry : docTypeResolutionEntries) {
            if (iDocTypeResolutionEntry.getPublicID().isNone()) {
                logBuilder.line("[THYMELEAF]         * SYSTEM \"{}\"", new Object[]{iDocTypeResolutionEntry.getSystemID().isAny() ? "*" : iDocTypeResolutionEntry.getSystemID()});
                continue;
            }
            logBuilder.line("[THYMELEAF]         * PUBLIC \"{}\" \"{}\"", new Object[]{iDocTypeResolutionEntry.getPublicID().isAny() ? "*" : iDocTypeResolutionEntry.getPublicID(), iDocTypeResolutionEntry.getSystemID().isAny() ? "*" : iDocTypeResolutionEntry.getSystemID()});
        }
    }

    private ConfigurationPrinterHelper() {
    }

    private static class ConfigLogBuilder {
        private static final String PLACEHOLDER = "\\{\\}";
        private final StringBuilder strBuilder = new StringBuilder();

        protected ConfigLogBuilder() {
        }

        protected void end(String line) {
            this.strBuilder.append(line);
        }

        protected void line(String line) {
            this.strBuilder.append(line + "\n");
        }

        protected void line(String line, Object p1) {
            this.strBuilder.append(this.replace(line, p1) + "\n");
        }

        protected void line(String line, Object p1, Object p2) {
            this.strBuilder.append(this.replace(this.replace(line, p1), p2) + "\n");
        }

        protected void line(String line, Object[] pArr) {
            String newLine = line;
            for (int i = 0; i < pArr.length; ++i) {
                newLine = this.replace(newLine, pArr[i]);
            }
            this.strBuilder.append(newLine + "\n");
        }

        public String toString() {
            return this.strBuilder.toString();
        }

        private String replace(String str, Object replacement) {
            return str.replaceFirst(PLACEHOLDER, this.param(replacement));
        }

        private String param(Object p) {
            if (p == null) {
                return null;
            }
            return p.toString();
        }
    }
}

