/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.doctype;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.regex.Pattern;
import org.thymeleaf.util.Validate;

public final class DocTypeIdentifier
implements Serializable {
    private static final long serialVersionUID = -2899688477489960285L;
    public static final DocTypeIdentifier ANY = new DocTypeIdentifier(false, true, null);
    public static final DocTypeIdentifier NONE = new DocTypeIdentifier(true, false, null);
    private final boolean none;
    private final boolean any;
    private final String value;
    private final Pattern valuePattern;

    public static DocTypeIdentifier forAny() {
        return ANY;
    }

    public static DocTypeIdentifier forNone() {
        return NONE;
    }

    public static DocTypeIdentifier forValue(String value) {
        if (value == null || value.equals("")) {
            return NONE;
        }
        return new DocTypeIdentifier(false, false, value);
    }

    private DocTypeIdentifier(boolean none, boolean any, String value) {
        this.none = none;
        this.any = any;
        this.value = value;
        this.valuePattern = null == value ? null : Pattern.compile(value);
    }

    public boolean isNone() {
        return this.none;
    }

    public boolean isAny() {
        return this.any;
    }

    public String getValue() {
        return this.value;
    }

    public boolean matches(String identifier) {
        boolean matches = false;
        if (this.isAny()) {
            matches = true;
        } else if (this.isNone()) {
            matches = identifier == null;
        } else if (identifier != null) {
            matches = this.valuePattern.matcher(identifier).matches();
        }
        return matches;
    }

    public boolean matches(DocTypeIdentifier identifier) {
        Validate.notNull(identifier, "Identifier cannot be null");
        boolean matches = false;
        matches = this.isAny() ? true : (this.isNone() ? identifier.isNone() : this.value.equals(identifier.value));
        return matches;
    }

    public String toString() {
        if (this.isNone()) {
            return "(NONE)";
        }
        if (this.isAny()) {
            return "(ANY)";
        }
        return this.value;
    }

    public void write(Writer writer) throws IOException {
        if (!this.isNone()) {
            if (this.isAny()) {
                writer.write("*");
            } else {
                writer.write(this.value);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.any ? 1231 : 1237);
        result = 31 * result + (this.none ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocTypeIdentifier other = (DocTypeIdentifier)obj;
        if (this.any != other.any) {
            return false;
        }
        if (this.none != other.none) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

