/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dom;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.thymeleaf.Configuration;
import org.thymeleaf.doctype.DocTypeIdentifier;
import org.thymeleaf.doctype.translation.IDocTypeTranslation;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.util.Validate;
import org.w3c.dom.DocumentType;

public final class DocType
implements Serializable {
    private static final long serialVersionUID = -5122946925754578948L;
    private final String originalDocTypeClause;
    private final String rootElementName;
    private final String publicId;
    private final String systemId;
    private final char[] firstToken;
    private final char[] thirdToken;
    private boolean processed;
    private DocTypeIdentifier processedPublicId;
    private DocTypeIdentifier processedSystemId;

    public DocType(String rootElementName, String publicId, String systemId) {
        this(rootElementName, publicId, systemId, null);
    }

    public DocType(String rootElementName, String publicId, String systemId, String originalDocTypeClause) {
        Validate.notNull(rootElementName, "Root element name cannot be null");
        this.originalDocTypeClause = originalDocTypeClause;
        this.rootElementName = rootElementName;
        this.publicId = publicId;
        this.systemId = systemId;
        this.processed = false;
        this.processedPublicId = null;
        this.processedSystemId = null;
        if (this.originalDocTypeClause != null) {
            String[] docTypeClauseTokens = DocType.extractDocTypeTokens(this.originalDocTypeClause);
            this.firstToken = docTypeClauseTokens[0] == null ? null : docTypeClauseTokens[0].toCharArray();
            this.thirdToken = docTypeClauseTokens[2] == null ? null : docTypeClauseTokens[2].toCharArray();
        } else {
            this.firstToken = null;
            this.thirdToken = null;
        }
    }

    public String getOriginalDocTypeClause() {
        return this.originalDocTypeClause;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public DocTypeIdentifier getProcessedPublicId() {
        return this.processedPublicId;
    }

    public DocTypeIdentifier getProcessedSystemId() {
        return this.processedSystemId;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void process(Configuration configuration) {
        IDocTypeTranslation translation;
        if (!this.processed && (translation = configuration.getDocTypeTranslationBySource(this.publicId, this.systemId)) != null) {
            this.processedPublicId = translation.getTargetPublicID();
            this.processedSystemId = translation.getTargetSystemID();
            this.processed = true;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rootElementName.hashCode();
        result = 31 * result + (this.publicId == null ? 0 : this.publicId.hashCode());
        result = 31 * result + (this.systemId == null ? 0 : this.systemId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocType other = (DocType)obj;
        if (!this.rootElementName.equals(other.rootElementName)) {
            return false;
        }
        if (this.publicId == null ? other.publicId != null : !this.publicId.equals(other.publicId)) {
            return false;
        }
        return !(this.systemId == null ? other.systemId != null : !this.systemId.equals(other.systemId));
    }

    private static String[] extractDocTypeTokens(String docTypeClause) {
        try {
            int docTypeClauseLen = docTypeClause.length();
            boolean inToken = true;
            int tokenDelim = 0;
            int currentToken = 0;
            String[] result = new String[3];
            for (int i = 0; i < docTypeClauseLen; ++i) {
                char c = docTypeClause.charAt(i);
                if (c == ' ' || c == '\t' || c == '>') {
                    if (!inToken) continue;
                    result[currentToken++] = docTypeClause.substring(tokenDelim, i).trim();
                    tokenDelim = i;
                    inToken = false;
                    if (currentToken <= 2) continue;
                    return result;
                }
                inToken = true;
            }
            return result;
        }
        catch (Exception e) {
            throw new TemplateInputException("DOCTYPE clause has bad format: \"" + docTypeClause + "\"");
        }
    }

    public void write(Writer writer) throws IOException {
        DocTypeIdentifier writablePublicId = this.getProcessedPublicId();
        DocTypeIdentifier writableSystemId = this.getProcessedSystemId();
        if (!this.isProcessed()) {
            writablePublicId = DocTypeIdentifier.forValue(this.getPublicId());
            writableSystemId = DocTypeIdentifier.forValue(this.getSystemId());
        }
        writer.write(this.firstToken);
        writer.write(32);
        writer.write(this.getRootElementName());
        if (!writablePublicId.isNone()) {
            writer.write(32);
            if (!this.isProcessed()) {
                writer.write(this.thirdToken);
            } else {
                writer.write("PUBLIC");
            }
            writer.write(" \"");
            writablePublicId.write(writer);
            writer.write("\"");
        }
        if (!writableSystemId.isNone()) {
            if (writablePublicId.isNone()) {
                writer.write(32);
                if (!this.isProcessed()) {
                    writer.write(this.thirdToken);
                } else {
                    writer.write("SYSTEM");
                }
            }
            writer.write(" \"");
            writableSystemId.write(writer);
            writer.write("\"");
        }
        writer.write(">");
    }

    @Deprecated
    public static final DocType translateDOMDocumentType(DocumentType domDocumentType) {
        if (domDocumentType == null) {
            return null;
        }
        String rootElementName = domDocumentType.getName();
        return new DocType(rootElementName, domDocumentType.getPublicId(), domDocumentType.getSystemId());
    }
}

