/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.AdditionExpression;
import org.thymeleaf.standard.expression.AdditionSubtractionExpression;
import org.thymeleaf.standard.expression.AndExpression;
import org.thymeleaf.standard.expression.ConditionalExpression;
import org.thymeleaf.standard.expression.DefaultExpression;
import org.thymeleaf.standard.expression.DivisionExpression;
import org.thymeleaf.standard.expression.EqualsExpression;
import org.thymeleaf.standard.expression.EqualsNotEqualsExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.GreaterLesserExpression;
import org.thymeleaf.standard.expression.GreaterOrEqualToExpression;
import org.thymeleaf.standard.expression.GreaterThanExpression;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;
import org.thymeleaf.standard.expression.LessOrEqualToExpression;
import org.thymeleaf.standard.expression.LessThanExpression;
import org.thymeleaf.standard.expression.MinusExpression;
import org.thymeleaf.standard.expression.MultiplicationDivisionRemainderExpression;
import org.thymeleaf.standard.expression.MultiplicationExpression;
import org.thymeleaf.standard.expression.NegationExpression;
import org.thymeleaf.standard.expression.NotEqualsExpression;
import org.thymeleaf.standard.expression.OrExpression;
import org.thymeleaf.standard.expression.RemainderExpression;
import org.thymeleaf.standard.expression.SubtractionExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComplexExpression
extends Expression {
    private static final long serialVersionUID = -3807499386899890260L;

    protected ComplexExpression() {
    }

    static List<ExpressionParsingNode> composeComplexExpressions(List<ExpressionParsingNode> decomposition, int inputIndex) {
        if (decomposition == null) {
            return null;
        }
        if (decomposition.get(inputIndex).isExpression()) {
            return decomposition;
        }
        List<ExpressionParsingNode> result = decomposition;
        if ((result = ComplexExpression.tryComposeUnitaryExpression(result, inputIndex)) == null) {
            return null;
        }
        if (result.get(inputIndex).isExpression()) {
            return result;
        }
        if ((result = ConditionalExpression.composeConditionalExpression(result, inputIndex)) == null) {
            return null;
        }
        if (result.get(inputIndex).isExpression()) {
            return result;
        }
        if ((result = DefaultExpression.composeDefaultExpression(result, inputIndex)) == null) {
            return null;
        }
        if (result.get(inputIndex).isExpression()) {
            return result;
        }
        if ((result = OrExpression.composeOrExpression(result, inputIndex)) == null) {
            return null;
        }
        if (result.get(inputIndex).isExpression()) {
            return result;
        }
        if ((result = AndExpression.composeAndExpression(result, inputIndex)) == null) {
            return null;
        }
        if (result.get(inputIndex).isExpression()) {
            return result;
        }
        if ((result = EqualsNotEqualsExpression.composeEqualsNotEqualsExpression(result, inputIndex)) == null) {
            return null;
        }
        if (result.get(inputIndex).isExpression()) {
            return result;
        }
        if ((result = GreaterLesserExpression.composeGreaterLesserExpression(result, inputIndex)) == null) {
            return null;
        }
        if (result.get(inputIndex).isExpression()) {
            return result;
        }
        if ((result = AdditionSubtractionExpression.composeAdditionSubtractionExpression(result, inputIndex)) == null) {
            return null;
        }
        if (result.get(inputIndex).isExpression()) {
            return result;
        }
        if ((result = MultiplicationDivisionRemainderExpression.composeMultiplicationDivisionRemainderExpression(result, inputIndex)) == null) {
            return null;
        }
        if (result.get(inputIndex).isExpression()) {
            return result;
        }
        if ((result = MinusExpression.composeMinusExpression(result, inputIndex)) == null) {
            return null;
        }
        if (result.get(inputIndex).isExpression()) {
            return result;
        }
        result = NegationExpression.composeNegationExpression(result, inputIndex);
        return result;
    }

    private static List<ExpressionParsingNode> tryComposeUnitaryExpression(List<ExpressionParsingNode> decomposition, int inputIndex) {
        ExpressionParsingNode inputParsingNode = decomposition.get(inputIndex);
        List<ExpressionParsingNode> result = decomposition;
        String input = inputParsingNode.getInput();
        if (input == null || input.trim().equals("")) {
            return null;
        }
        int valueIndex = Expression.placeHolderToIndex(input);
        if (valueIndex != -1) {
            if ((result = ComplexExpression.composeComplexExpressions(result, valueIndex)) == null) {
                return null;
            }
            ExpressionParsingNode epn = result.get(valueIndex);
            Expression expr = epn.getExpression();
            if (expr == null) {
                return null;
            }
            result.set(inputIndex, new ExpressionParsingNode(expr));
        }
        return result;
    }

    static Object executeComplex(Arguments arguments, ComplexExpression expression, IStandardExpressionEvaluator expressionEvaluator) {
        if (expression instanceof AdditionExpression) {
            return AdditionExpression.executeAddition(arguments, (AdditionExpression)expression, expressionEvaluator);
        }
        if (expression instanceof SubtractionExpression) {
            return SubtractionExpression.executeSubtraction(arguments, (SubtractionExpression)expression, expressionEvaluator);
        }
        if (expression instanceof MultiplicationExpression) {
            return MultiplicationExpression.executeMultiplication(arguments, (MultiplicationExpression)expression, expressionEvaluator);
        }
        if (expression instanceof DivisionExpression) {
            return DivisionExpression.executeDivision(arguments, (DivisionExpression)expression, expressionEvaluator);
        }
        if (expression instanceof RemainderExpression) {
            return RemainderExpression.executeRemainder(arguments, (RemainderExpression)expression, expressionEvaluator);
        }
        if (expression instanceof ConditionalExpression) {
            return ConditionalExpression.executeConditional(arguments, (ConditionalExpression)expression, expressionEvaluator);
        }
        if (expression instanceof DefaultExpression) {
            return DefaultExpression.executeDefault(arguments, (DefaultExpression)expression, expressionEvaluator);
        }
        if (expression instanceof MinusExpression) {
            return MinusExpression.executeMinus(arguments, (MinusExpression)expression, expressionEvaluator);
        }
        if (expression instanceof NegationExpression) {
            return NegationExpression.executeNegation(arguments, (NegationExpression)expression, expressionEvaluator);
        }
        if (expression instanceof AndExpression) {
            return AndExpression.executeAnd(arguments, (AndExpression)expression, expressionEvaluator);
        }
        if (expression instanceof OrExpression) {
            return OrExpression.executeOr(arguments, (OrExpression)expression, expressionEvaluator);
        }
        if (expression instanceof EqualsExpression) {
            return EqualsExpression.executeEquals(arguments, (EqualsExpression)expression, expressionEvaluator);
        }
        if (expression instanceof NotEqualsExpression) {
            return NotEqualsExpression.executeNotEquals(arguments, (NotEqualsExpression)expression, expressionEvaluator);
        }
        if (expression instanceof GreaterThanExpression) {
            return GreaterThanExpression.executeGreaterThan(arguments, (GreaterThanExpression)expression, expressionEvaluator);
        }
        if (expression instanceof GreaterOrEqualToExpression) {
            return GreaterOrEqualToExpression.executeGreaterOrEqualTo(arguments, (GreaterOrEqualToExpression)expression, expressionEvaluator);
        }
        if (expression instanceof LessThanExpression) {
            return LessThanExpression.executeLessThan(arguments, (LessThanExpression)expression, expressionEvaluator);
        }
        if (expression instanceof LessOrEqualToExpression) {
            return LessOrEqualToExpression.executeLessOrEqualTo(arguments, (LessOrEqualToExpression)expression, expressionEvaluator);
        }
        throw new TemplateProcessingException("Unrecognized complex expression: " + expression.getClass().getName());
    }
}

