/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.standard.expression.EqualsNotEqualsExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.util.ObjectUtils;

public final class EqualsExpression
extends EqualsNotEqualsExpression {
    private static final long serialVersionUID = -3223406642461547141L;
    private static final Logger logger = LoggerFactory.getLogger(EqualsExpression.class);

    public EqualsExpression(Expression left, Expression right) {
        super(left, right);
    }

    public String getStringRepresentation() {
        return this.getStringRepresentation("==");
    }

    static Object executeEquals(Arguments arguments, EqualsExpression expression, IStandardExpressionEvaluator expressionEvaluator) {
        Object leftValue = Expression.execute(arguments, expression.getLeft(), expressionEvaluator);
        Object rightValue = Expression.execute(arguments, expression.getRight(), expressionEvaluator);
        leftValue = LiteralValue.unwrap(leftValue);
        rightValue = LiteralValue.unwrap(rightValue);
        if (leftValue == null) {
            return rightValue == null;
        }
        Boolean result = null;
        BigDecimal leftNumberValue = ObjectUtils.evaluateAsNumber(leftValue);
        BigDecimal rightNumberValue = ObjectUtils.evaluateAsNumber(rightValue);
        result = leftNumberValue != null && rightNumberValue != null ? Boolean.valueOf(leftNumberValue.compareTo(rightNumberValue) == 0) : (leftValue != null && rightValue != null && leftValue.getClass().equals(rightValue.getClass()) && Comparable.class.isAssignableFrom(leftValue.getClass()) ? Boolean.valueOf(((Comparable)leftValue).compareTo(rightValue) == 0) : Boolean.valueOf(leftValue.equals(rightValue)));
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating EQUALS expression: \"{}\". Left is \"{}\", right is \"{}\". Result is \"{}\"", new Object[]{TemplateEngine.threadIndex(), expression.getStringRepresentation(), leftValue, rightValue, result});
        }
        return result;
    }
}

