/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.Assignation;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.standard.expression.TextLiteralExpression;
import org.thymeleaf.standard.expression.Token;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkExpression
extends SimpleExpression {
    private static final Logger logger = LoggerFactory.getLogger(LinkExpression.class);
    private static final long serialVersionUID = -564516592085017252L;
    static final char SELECTOR = '@';
    private static final char PARAMS_START_CHAR = '(';
    private static final char PARAMS_END_CHAR = ')';
    private static final Pattern LINK_PATTERN = Pattern.compile("^\\s*\\@\\{(.+?)\\}\\s*$", 32);
    private static final List<Object> EMPTY_PARAMETER_VALUE = Collections.singletonList("");
    private final Expression base;
    private final AssignationSequence parameters;

    public LinkExpression(Expression base, AssignationSequence parameters) {
        Validate.notNull(base, "Base cannot be null");
        this.base = base;
        this.parameters = parameters;
    }

    public Expression getBase() {
        return this.base;
    }

    public AssignationSequence getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.size() > 0;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append('{');
        sb.append(this.base);
        if (this.hasParameters()) {
            sb.append('(');
            sb.append(this.parameters.getStringRepresentation());
            sb.append(')');
        }
        sb.append('}');
        return sb.toString();
    }

    static LinkExpression parseLink(String input) {
        Matcher matcher = LINK_PATTERN.matcher(input);
        if (!matcher.matches()) {
            return null;
        }
        String content = matcher.group(1);
        if (content == null || content.trim().equals("")) {
            return null;
        }
        String trimmedInput = content.trim();
        if (trimmedInput.endsWith(String.valueOf(')'))) {
            boolean inLiteral = false;
            int nestParLevel = 0;
            for (int i = trimmedInput.length() - 1; i >= 0; --i) {
                char c = trimmedInput.charAt(i);
                if (c == '\'') {
                    if (i != 0 && content.charAt(i - 1) == '\\') continue;
                    inLiteral = !inLiteral;
                    continue;
                }
                if (c == ')') {
                    ++nestParLevel;
                    continue;
                }
                if (c != '(') continue;
                if (--nestParLevel < 0) {
                    return null;
                }
                if (nestParLevel != 0) continue;
                if (i == 0) {
                    return null;
                }
                String base = trimmedInput.substring(0, i);
                String parameters = trimmedInput.substring(i + 1, trimmedInput.length() - 1);
                Expression baseExpr = LinkExpression.computeBase(base);
                if (baseExpr == null) {
                    return null;
                }
                AssignationSequence parametersAssigSeq = AssignationSequence.parse(parameters, true);
                if (parametersAssigSeq == null) {
                    return null;
                }
                return new LinkExpression(baseExpr, parametersAssigSeq);
            }
            return null;
        }
        Expression baseExpr = LinkExpression.computeBase(trimmedInput);
        if (baseExpr == null) {
            return null;
        }
        return new LinkExpression(baseExpr, null);
    }

    private static Expression computeBase(String baseStr) {
        Token token = Token.parse(baseStr);
        if (token != null) {
            return TextLiteralExpression.parseTextLiteral(token.getValue());
        }
        return Expression.parse(baseStr);
    }

    static Object executeLink(Arguments arguments, LinkExpression expression, IStandardExpressionEvaluator expressionEvaluator) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating link: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        Expression baseExpression = expression.getBase();
        Object base = Expression.execute(arguments, baseExpression, expressionEvaluator);
        if ((base = LiteralValue.unwrap(base)) == null || !(base instanceof String) || ((String)base).trim().equals("")) {
            throw new TemplateProcessingException("Base for message resolution must be a non-null and non-empty String (currently: " + (base == null ? null : base.getClass().getName()) + ")");
        }
        String linkBase = (String)base;
        if (!LinkExpression.isWebContext(arguments.getContext()) && !LinkExpression.isLinkBaseAbsolute(linkBase)) {
            throw new TemplateProcessingException("Link base \"" + linkBase + "\" is not absolute. Non-absolute links " + "can only be processed if context implements the " + IWebContext.class.getName() + " interface (context is of class: " + arguments.getContext().getClass().getName() + ")");
        }
        Map<String, List<Object>> parameters = expression.hasParameters() ? LinkExpression.resolveParameters(arguments, expression.getParameters(), expressionEvaluator) : Collections.EMPTY_MAP;
        int hashPosition = linkBase.indexOf(35);
        String urlFragment = "";
        if (hashPosition > 0) {
            urlFragment = linkBase.substring(hashPosition);
            linkBase = linkBase.substring(0, hashPosition);
        }
        int questionMarkPosition = linkBase.indexOf("?");
        StringBuffer parametersBuffer = new StringBuffer();
        for (Map.Entry<String, List<Object>> parameterEntry : parameters.entrySet()) {
            String parameterName = parameterEntry.getKey();
            List<Object> parameterValues = parameterEntry.getValue();
            if (parameterValues == null) {
                if (parametersBuffer.length() == 0) {
                    if (questionMarkPosition == -1) {
                        parametersBuffer.append("?");
                    } else {
                        parametersBuffer.append("&");
                    }
                } else {
                    parametersBuffer.append("&");
                }
                parametersBuffer.append(parameterName);
                continue;
            }
            for (Object parameterObjectValue : parameterEntry.getValue()) {
                if (parametersBuffer.length() == 0) {
                    if (questionMarkPosition == -1) {
                        parametersBuffer.append("?");
                    } else {
                        parametersBuffer.append("&");
                    }
                } else {
                    parametersBuffer.append("&");
                }
                String parameterValue = parameterObjectValue == null ? "" : parameterObjectValue.toString();
                try {
                    parametersBuffer.append(parameterName + "=" + URLEncoder.encode(parameterValue, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new TemplateProcessingException("Exception while processing link parameters", e);
                }
            }
        }
        if (LinkExpression.isLinkBaseAbsolute(linkBase)) {
            return linkBase + parametersBuffer.toString() + urlFragment;
        }
        IWebContext webContext = (IWebContext)arguments.getContext();
        String sessionFragment = "";
        HttpServletRequest request = webContext.getHttpServletRequest();
        HttpSession session = webContext.getHttpSession();
        if (null != session) {
            String sessionID = session.getId();
            if (!request.isRequestedSessionIdFromCookie()) {
                sessionFragment = ";jsessionid=" + sessionID;
            }
        }
        if (LinkExpression.isLinkBaseContextRelative(linkBase)) {
            String contextName = request.getContextPath();
            if (questionMarkPosition == -1) {
                return contextName + linkBase + sessionFragment + parametersBuffer.toString() + urlFragment;
            }
            String linkBasePart1 = linkBase.substring(0, questionMarkPosition);
            String linkBasePart2 = linkBase.substring(questionMarkPosition);
            return contextName + linkBasePart1 + sessionFragment + linkBasePart2 + parametersBuffer.toString() + urlFragment;
        }
        if (LinkExpression.isLinkBaseServerRelative(linkBase)) {
            if (questionMarkPosition == -1) {
                return linkBase.substring(1) + sessionFragment + parametersBuffer.toString() + urlFragment;
            }
            String linkBasePart1 = linkBase.substring(0, questionMarkPosition);
            String linkBasePart2 = linkBase.substring(questionMarkPosition);
            return linkBasePart1.substring(1) + sessionFragment + linkBasePart2 + parametersBuffer.toString() + urlFragment;
        }
        return linkBase + sessionFragment + parametersBuffer.toString() + urlFragment;
    }

    private static boolean isWebContext(IContext context) {
        return context instanceof IWebContext;
    }

    private static boolean isLinkBaseAbsolute(String linkBase) {
        return linkBase.contains("://") || linkBase.toLowerCase().startsWith("mailto:");
    }

    private static boolean isLinkBaseContextRelative(String linkBase) {
        return linkBase.startsWith("/");
    }

    private static boolean isLinkBaseServerRelative(String linkBase) {
        return linkBase.startsWith("~/");
    }

    private static Map<String, List<Object>> resolveParameters(Arguments arguments, AssignationSequence assignationValues, IStandardExpressionEvaluator expressionEvaluator) {
        LinkedHashMap<String, List<Object>> parameters = new LinkedHashMap<String, List<Object>>(assignationValues.size() + 1, 1.0f);
        for (Assignation assignationValue : assignationValues) {
            String parameterName = assignationValue.getLeft().getValue();
            Expression parameterExpression = assignationValue.getRight();
            if (parameterExpression == null) {
                parameters.put(parameterName, null);
                continue;
            }
            Object value = Expression.execute(arguments, parameterExpression, expressionEvaluator);
            if (value == null) {
                parameters.put(parameterName, EMPTY_PARAMETER_VALUE);
                continue;
            }
            parameters.put(parameterName, LinkExpression.convertParameterValueToList(LiteralValue.unwrap(value)));
        }
        return parameters;
    }

    private static List<Object> convertParameterValueToList(Object parameterValue) {
        if (parameterValue instanceof Iterable) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object obj : (Iterable)parameterValue) {
                result.add(obj);
            }
            return result;
        }
        if (parameterValue.getClass().isArray()) {
            ArrayList<Object> result = new ArrayList<Object>();
            if (parameterValue instanceof byte[]) {
                for (byte obj : (byte[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof short[]) {
                for (short obj : (short[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof int[]) {
                for (int obj : (int[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof long[]) {
                for (long obj : (long[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof float[]) {
                for (float obj : (float[])parameterValue) {
                    result.add(Float.valueOf(obj));
                }
            } else if (parameterValue instanceof double[]) {
                for (double obj : (double[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof boolean[]) {
                for (boolean obj : (boolean[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof char[]) {
                for (char obj : (char[])parameterValue) {
                    result.add(Character.valueOf(obj));
                }
            } else {
                for (Object obj : (Object[])parameterValue) {
                    result.add(obj);
                }
            }
            return result;
        }
        return Collections.singletonList(parameterValue);
    }
}

