/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.Collections;
import java.util.Map;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import ognl.Ognl;
import ognl.OgnlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OgnlExpressionEvaluator
implements IStandardExpressionEvaluator {
    public static final OgnlExpressionEvaluator INSTANCE = new OgnlExpressionEvaluator();
    private static final String OGNL_CACHE_PREFIX = "{ognl}";
    private static final Logger logger = LoggerFactory.getLogger(OgnlExpressionEvaluator.class);
    private static boolean booleanFixApplied = false;

    @Override
    public final Object evaluate(Arguments arguments, String expression, Object root) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] OGNL expression: evaluating expression \"{}\" on target", (Object)TemplateEngine.threadIndex(), (Object)expression);
            }
            Object expressionTree = null;
            ICache<String, Object> cache = null;
            ICacheManager cacheManager = arguments.getConfiguration().getCacheManager();
            if (cacheManager != null && (cache = cacheManager.getExpressionCache()) != null) {
                expressionTree = cache.get(OGNL_CACHE_PREFIX + expression);
            }
            if (expressionTree == null) {
                expressionTree = Ognl.parseExpression((String)expression);
                if (cache != null && null != expressionTree) {
                    cache.put(OGNL_CACHE_PREFIX + expression, expressionTree);
                }
            }
            Map<String, Object> contextVariables = arguments.getBaseContextVariables();
            Map<String, Object> additionalContextVariables = this.computeAdditionalContextVariables(arguments);
            if (additionalContextVariables != null && !additionalContextVariables.isEmpty()) {
                contextVariables.putAll(additionalContextVariables);
            }
            return Ognl.getValue((Object)expressionTree, contextVariables, (Object)root);
        }
        catch (OgnlException e) {
            throw new TemplateProcessingException("Exception evaluating OGNL expression: \"" + expression + "\"", e);
        }
    }

    protected Map<String, Object> computeAdditionalContextVariables(Arguments arguments) {
        return Collections.emptyMap();
    }

    private OgnlExpressionEvaluator() {
        if (!booleanFixApplied && this.shouldApplyOgnlBooleanFix()) {
            OgnlExpressionEvaluator.applyOgnlBooleanFix();
            booleanFixApplied = true;
        }
    }

    public String toString() {
        return "OGNL";
    }

    protected boolean shouldApplyOgnlBooleanFix() {
        return true;
    }

    private static void applyOgnlBooleanFix() {
        try {
            ClassLoader classLoader = ClassLoaderUtils.getClassLoader(OgnlExpressionEvaluator.class);
            ClassPool pool = new ClassPool(true);
            pool.insertClassPath((ClassPath)new LoaderClassPath(classLoader));
            CtClass[] params = new CtClass[]{pool.get(Object.class.getName())};
            CtClass ognlClass = pool.get("ognl.OgnlOps");
            CtClass fixClass = pool.get(OgnlExpressionEvaluator.class.getName());
            CtMethod ognlMethod = ognlClass.getDeclaredMethod("booleanValue", params);
            CtMethod fixMethod = fixClass.getDeclaredMethod("fixBooleanValue", params);
            ognlMethod.setBody(fixMethod, null);
            ognlClass.toClass(classLoader, null);
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace("Thymeleaf was not able to apply a fix on OGNL's boolean evaluation that would have enabled OGNL to evaluate Strings as booleans (e.g. in \"th:if\") in exactly the same way as Thymeleaf itself or Spring EL ('false', 'off' and 'no' should be considered \"false\"). This did not stop the initialization process.", (Throwable)e);
            }
            logger.info("Thymeleaf was not able to apply a fix on OGNL's boolean evaluation that would have enabled OGNL to evaluate Strings as booleans (e.g. in \"th:if\") in exactly the same way as Thymeleaf itself or Spring EL ('false', 'off' and 'no' should be considered \"false\"). This did not stop the initialization process. Exception raised was " + e.getClass().getName() + ": " + e.getMessage() + " [Set the log to TRACE for the complete exception stack trace]");
        }
    }

    static boolean fixBooleanValue(Object value) {
        return ObjectUtils.evaluateAsBoolean(value);
    }
}

