/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.util.Validate;

public final class SelectionVariableExpression
extends SimpleExpression {
    private static final Logger logger = LoggerFactory.getLogger(SelectionVariableExpression.class);
    private static final long serialVersionUID = 854441190427550056L;
    static final char SELECTOR = '*';
    private static final Pattern SELECTION_VAR_PATTERN = Pattern.compile("^\\s*\\*\\{(.+?)\\}\\s*$", 32);
    private final String expression;

    public SelectionVariableExpression(String expression) {
        Validate.notNull(expression, "Expression cannot be null");
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getStringRepresentation() {
        return String.valueOf('*') + String.valueOf('{') + this.expression + String.valueOf('}');
    }

    static SelectionVariableExpression parseSelectionVariable(String input) {
        Matcher matcher = SELECTION_VAR_PATTERN.matcher(input);
        if (!matcher.matches()) {
            return null;
        }
        return new SelectionVariableExpression(matcher.group(1));
    }

    static Object executeSelectionVariable(Arguments arguments, SelectionVariableExpression expression, IStandardExpressionEvaluator expressionEvaluator) {
        String exp;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating selection variable expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        if ((exp = expression.getExpression()) == null) {
            throw new TemplateProcessingException("Variable expression is null, which is not allowed");
        }
        Object evaluationRoot = arguments.getExpressionSelectionEvaluationRoot();
        return expressionEvaluator.evaluate(arguments, exp, evaluationRoot);
    }
}

