/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.thymeleaf.Arguments;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.util.Validate;

public final class StandardExpressionExecutor {
    private final IStandardExpressionEvaluator expressionEvaluator;

    StandardExpressionExecutor(IStandardExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    public Object executeExpression(Arguments arguments, Expression expression) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(expression, "Expression cannot be null");
        Object result = Expression.execute(arguments, expression, this.expressionEvaluator);
        return LiteralValue.unwrap(result);
    }

    public String toString() {
        return "Standard Expression Executor with expression evaluator: " + this.expressionEvaluator.toString();
    }
}

