/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.thymeleaf.Arguments;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.Each;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionCache;
import org.thymeleaf.standard.expression.ExpressionSequence;
import org.thymeleaf.standard.expression.FragmentSelection;
import org.thymeleaf.standard.expression.StandardExpressionExecutor;
import org.thymeleaf.util.DOMUtils;
import org.thymeleaf.util.Validate;

public final class StandardExpressionParser {
    private final StandardExpressionExecutor executor;
    private static final char PREPROCESS_DELIMITER = '_';
    private static final String PREPROCESS_EVAL = "\\_\\_(.*?)\\_\\_";
    private static final Pattern PREPROCESS_EVAL_PATTERN = Pattern.compile("\\_\\_(.*?)\\_\\_", 32);
    private static final ExpressionCache CACHE = new ExpressionCache();

    StandardExpressionParser(StandardExpressionExecutor executor) {
        this.executor = executor;
    }

    public Expression parseExpression(Arguments arguments, String input) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return this.parseExpression(arguments, DOMUtils.unescapeXml(input, true), true);
    }

    public AssignationSequence parseAssignationSequence(Arguments arguments, String input, boolean allowParametersWithoutValue) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return this.parseAssignationSequence(arguments, DOMUtils.unescapeXml(input, true), true, allowParametersWithoutValue);
    }

    public ExpressionSequence parseExpressionSequence(Arguments arguments, String input) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return this.parseExpressionSequence(arguments, DOMUtils.unescapeXml(input, true), true);
    }

    public Each parseEach(Arguments arguments, String input) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return this.parseEach(arguments, DOMUtils.unescapeXml(input, true), true);
    }

    public FragmentSelection parseFragmentSelection(Arguments arguments, String input) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return this.parseFragmentSelection(arguments, DOMUtils.unescapeXml(input, true), true);
    }

    Expression parseExpression(Arguments arguments, String input, boolean preprocess) {
        String trimmedInput = input.trim();
        String preprocessedInput = preprocess ? this.preprocess(arguments, trimmedInput) : trimmedInput;
        Expression cachedExpression = CACHE.getExpressionFromCache(arguments.getConfiguration(), preprocessedInput);
        if (cachedExpression != null) {
            return cachedExpression;
        }
        Expression expression = Expression.parse(preprocessedInput);
        if (expression == null) {
            throw new TemplateProcessingException("Could not parse as expression: \"" + input + "\"");
        }
        CACHE.putExpressionIntoCache(arguments.getConfiguration(), preprocessedInput, expression);
        return expression;
    }

    AssignationSequence parseAssignationSequence(Arguments arguments, String input, boolean preprocess, boolean allowParametersWithoutValue) {
        String trimmedInput = input.trim();
        String preprocessedInput = preprocess ? this.preprocess(arguments, trimmedInput) : trimmedInput;
        AssignationSequence cachedAssignationSequence = CACHE.getAssignationSequenceFromCache(arguments.getConfiguration(), preprocessedInput);
        if (cachedAssignationSequence != null) {
            return cachedAssignationSequence;
        }
        AssignationSequence assignationSequence = AssignationSequence.parse(preprocessedInput, allowParametersWithoutValue);
        if (assignationSequence == null) {
            throw new TemplateProcessingException("Could not parse as assignation sequence: \"" + input + "\"");
        }
        CACHE.putAssignationSequenceIntoCache(arguments.getConfiguration(), preprocessedInput, assignationSequence);
        return assignationSequence;
    }

    ExpressionSequence parseExpressionSequence(Arguments arguments, String input, boolean preprocess) {
        String trimmedInput = input.trim();
        String preprocessedInput = preprocess ? this.preprocess(arguments, trimmedInput) : trimmedInput;
        ExpressionSequence cachedExpressionSequence = CACHE.getExpressionSequenceFromCache(arguments.getConfiguration(), preprocessedInput);
        if (cachedExpressionSequence != null) {
            return cachedExpressionSequence;
        }
        ExpressionSequence expressionSequence = ExpressionSequence.parse(preprocessedInput);
        if (expressionSequence == null) {
            throw new TemplateProcessingException("Could not parse as expression sequence: \"" + input + "\"");
        }
        CACHE.putExpressionSequenceIntoCache(arguments.getConfiguration(), preprocessedInput, expressionSequence);
        return expressionSequence;
    }

    Each parseEach(Arguments arguments, String input, boolean preprocess) {
        String trimmedInput = input.trim();
        String preprocessedInput = preprocess ? this.preprocess(arguments, trimmedInput) : trimmedInput;
        Each cachedEach = CACHE.getEachFromCache(arguments.getConfiguration(), preprocessedInput);
        if (cachedEach != null) {
            return cachedEach;
        }
        Each each = Each.parse(preprocessedInput);
        if (each == null) {
            throw new TemplateProcessingException("Could not parse as each: \"" + input + "\"");
        }
        CACHE.putEachIntoCache(arguments.getConfiguration(), preprocessedInput, each);
        return each;
    }

    FragmentSelection parseFragmentSelection(Arguments arguments, String input, boolean preprocess) {
        String trimmedInput = input.trim();
        String preprocessedInput = preprocess ? this.preprocess(arguments, trimmedInput) : trimmedInput;
        FragmentSelection cachedFragmentSelection = CACHE.getFragmentSelectionFromCache(arguments.getConfiguration(), preprocessedInput);
        if (cachedFragmentSelection != null) {
            return cachedFragmentSelection;
        }
        FragmentSelection fragmentSelection = FragmentSelection.parse(preprocessedInput);
        if (fragmentSelection == null) {
            throw new TemplateProcessingException("Could not parse as fragment selection: \"" + input + "\"");
        }
        CACHE.putFragmentSelectionIntoCache(arguments.getConfiguration(), preprocessedInput, fragmentSelection);
        return fragmentSelection;
    }

    String preprocess(Arguments arguments, String input) {
        if (input.indexOf(95) == -1) {
            return input;
        }
        Matcher matcher = PREPROCESS_EVAL_PATTERN.matcher(input);
        if (matcher.find()) {
            StringBuilder strBuilder = new StringBuilder();
            int curr = 0;
            do {
                strBuilder.append(input.substring(curr, matcher.start(0)));
                Expression expression = this.parseExpression(arguments, matcher.group(1), false);
                if (expression == null) {
                    return null;
                }
                Object result = this.executor.executeExpression(arguments, expression);
                strBuilder.append(result);
                curr = matcher.end(0);
            } while (matcher.find());
            strBuilder.append(input.substring(curr));
            return strBuilder.toString().trim();
        }
        return input;
    }

    public String toString() {
        return "Standard Expression Parser";
    }
}

