/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.exceptions.TemplateInputException;

public final class TemplatePreprocessingReader
extends Reader {
    private static final Logger readerLogger = LoggerFactory.getLogger(TemplatePreprocessingReader.class);
    public static final char CHAR_ENTITY_START_SUBSTITUTE = '\ufff8';
    private static final char CHAR_OPTIONAL_WHITESPACE_WILDCARD = '\u0358';
    private static final char CHAR_WHITESPACE_WILDCARD = '\u0359';
    private static final char CHAR_ALPHANUMERIC_WILDCARD = '\u0360';
    private static final char CHAR_ANY_WILDCARD = '\u0361';
    private static final char[] LOWER_CHARS = ("[]<>!=-_.,:;+*()&/%$\"'@#~^ \t\n\rabcdefghijklmnopqrstuvwxyz" + String.valueOf('\u0358') + String.valueOf('\u0359') + String.valueOf('\u0360') + String.valueOf('\u0361')).toCharArray();
    private static final char[] UPPER_CHARS = ("[]<>!=-_.,:;+*()&/%$\"'@#~^ \t\n\rABCDEFGHIJKLMNOPQRSTUVWXYZ" + String.valueOf('\u0358') + String.valueOf('\u0359') + String.valueOf('\u0360') + String.valueOf('\u0361')).toCharArray();
    private static final int[] COMMENT_START = TemplatePreprocessingReader.convertToIndexes("<!--");
    private static final int[] COMMENT_END = TemplatePreprocessingReader.convertToIndexes("-->");
    private static final int[] ENTITY = TemplatePreprocessingReader.convertToIndexes("&" + String.valueOf('\u0360') + ";");
    private static final int[] DOCTYPE = TemplatePreprocessingReader.convertToIndexes("<!DOCTYPE" + String.valueOf('\u0359') + String.valueOf('\u0361') + ">");
    private static final char[] NORMALIZED_DOCTYPE_PREFIX = "<!DOCTYPE ".toCharArray();
    private static final char[] NORMALIZED_DOCTYPE_PUBLIC = "PUBLIC ".toCharArray();
    private static final char[] NORMALIZED_DOCTYPE_SYSTEM = "SYSTEM ".toCharArray();
    private static final char[] ENTITY_START_SUBSTITUTE_CHAR_ARRAY = new char[]{'\ufff8'};
    private final BufferedReader bufferedReader;
    private char[] buffer;
    private char[] overflow;
    private int overflowIndex;
    private boolean inComment = false;
    private boolean docTypeClauseRead = false;
    private boolean noMoreToRead = false;
    private String docTypeClause = null;

    private static int[] convertToIndexes(String str) {
        int strLen = str.length();
        int[] result = new int[strLen];
        for (int i = 0; i < strLen; ++i) {
            int j;
            char c = str.charAt(i);
            boolean found = false;
            for (j = 0; !found && j < UPPER_CHARS.length; ++j) {
                if (UPPER_CHARS[j] != c) continue;
                result[i] = j;
                found = true;
            }
            for (j = 0; !found && j < LOWER_CHARS.length; ++j) {
                if (LOWER_CHARS[j] != c) continue;
                result[i] = j;
                found = true;
            }
            if (found) continue;
            throw new RuntimeException("Cannot convert to index character: '" + c + "' (value: " + c + ")");
        }
        return result;
    }

    public TemplatePreprocessingReader(Reader in, int bufferSize) {
        this.bufferedReader = new BufferedReader(in, bufferSize);
        this.buffer = new char[bufferSize + 1024];
        this.overflow = new char[bufferSize + 2048];
        this.overflowIndex = 0;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int copied;
        int toBeOverFlowed;
        int copied2;
        if (readerLogger.isTraceEnabled()) {
            readerLogger.trace("[THYMELEAF][TEMPLATEPREPROCESSINGREADER][{}] CALLING read(char[], {}, {})", new Object[]{TemplateEngine.threadIndex(), off, len});
        }
        if (len * 2 > this.overflow.length) {
            this.buffer = new char[len + 1024];
            char[] newOverflow = new char[len + 2048];
            System.arraycopy(this.overflow, 0, newOverflow, 0, this.overflowIndex);
            this.overflow = newOverflow;
        }
        int bufferSize = 0;
        if (this.overflowIndex > 0) {
            int copied3 = this.copyToResult(this.overflow, 0, this.overflowIndex, this.buffer, 0, this.buffer.length);
            bufferSize += copied3;
            if (readerLogger.isTraceEnabled()) {
                readerLogger.trace("[THYMELEAF][TEMPLATEPREPROCESSINGREADER][{}] READ FROM OVERFLOW BUFFER {} Some content from the overflow buffer has been copied into results.", new Object[]{TemplateEngine.threadIndex(), copied3});
            }
        }
        char[] overflowOverflow = null;
        if (this.overflowIndex > 0) {
            overflowOverflow = new char[this.overflowIndex];
            System.arraycopy(this.overflow, 0, overflowOverflow, 0, this.overflowIndex);
            if (readerLogger.isTraceEnabled()) {
                readerLogger.trace("[THYMELEAF][TEMPLATEPREPROCESSINGREADER][{}] RELLOCATED SOME OVERFLOW CONTENTS, WAITING TO BE ADDED TO RESULT/NEW OVERFLOW {} Some content was remaining at the overflow buffer and will have to be rellocated.", new Object[]{TemplateEngine.threadIndex(), this.overflowIndex});
            }
            this.overflowIndex = 0;
        }
        if (!this.noMoreToRead && bufferSize < this.buffer.length) {
            int toBeRead = this.buffer.length - bufferSize;
            int reallyRead = this.bufferedReader.read(this.buffer, bufferSize, toBeRead);
            if (readerLogger.isTraceEnabled()) {
                readerLogger.trace("[THYMELEAF][TEMPLATEPREPROCESSINGREADER][{}] READ FROM SOURCE {} A read operation was executed on the source reader (max chars requested: {}).", new Object[]{TemplateEngine.threadIndex(), reallyRead, toBeRead});
            }
            if (reallyRead < 0) {
                if (bufferSize == 0) {
                    if (readerLogger.isTraceEnabled()) {
                        readerLogger.trace("[THYMELEAF][TEMPLATEPREPROCESSINGREADER][{}] RETURN {} After trying to read from input: No input left, no buffer left.", new Object[]{TemplateEngine.threadIndex(), reallyRead});
                    }
                    return reallyRead;
                }
                this.noMoreToRead = true;
            } else {
                bufferSize += reallyRead;
            }
        }
        if (this.noMoreToRead && bufferSize == 0) {
            if (readerLogger.isTraceEnabled()) {
                readerLogger.trace("[THYMELEAF][TEMPLATEPREPROCESSINGREADER][{}] RETURN -1 Reader was already marked to be finished. No more input, no more buffer.", new Object[]{TemplateEngine.threadIndex()});
            }
            return -1;
        }
        int totalRead = 0;
        int cbufi = off;
        int last = off + len;
        int buffi = 0;
        while (cbufi < last && buffi < bufferSize) {
            int copied4;
            int matchedEntity;
            int matchedDocType;
            if (!this.docTypeClauseRead && (matchedDocType = TemplatePreprocessingReader.match(DOCTYPE, 0, DOCTYPE.length, this.buffer, buffi, bufferSize)) > 0) {
                this.docTypeClause = new String(this.buffer, buffi, matchedDocType);
                this.docTypeClauseRead = true;
                char[] normalizedDocType = TemplatePreprocessingReader.normalizeDocTypeClause(this.buffer, buffi, matchedDocType);
                int copied5 = this.copyToResult(normalizedDocType, 0, matchedDocType, cbuf, cbufi, last);
                cbufi += copied5;
                totalRead += copied5;
                buffi += matchedDocType;
                continue;
            }
            int matchedStartOfComment = this.inComment ? -2 : TemplatePreprocessingReader.match(COMMENT_START, 0, COMMENT_START.length, this.buffer, buffi, bufferSize);
            int matchedEndOfComment = this.inComment ? TemplatePreprocessingReader.match(COMMENT_END, 0, COMMENT_END.length, this.buffer, buffi, bufferSize) : -2;
            int n = matchedEntity = this.inComment ? -2 : TemplatePreprocessingReader.match(ENTITY, 0, ENTITY.length, this.buffer, buffi, bufferSize);
            if (matchedStartOfComment > 0) {
                this.inComment = true;
                copied4 = this.copyToResult(this.buffer, buffi, matchedStartOfComment, cbuf, cbufi, last);
                cbufi += copied4;
                totalRead += copied4;
                buffi += matchedStartOfComment;
                continue;
            }
            if (matchedEndOfComment > 0) {
                this.inComment = false;
                copied4 = this.copyToResult(this.buffer, buffi, matchedEndOfComment, cbuf, cbufi, last);
                cbufi += copied4;
                totalRead += copied4;
                buffi += matchedEndOfComment;
                continue;
            }
            if (matchedEntity > 0) {
                copied4 = this.copyToResult(ENTITY_START_SUBSTITUTE_CHAR_ARRAY, 0, ENTITY_START_SUBSTITUTE_CHAR_ARRAY.length, cbuf, cbufi, last);
                cbufi += copied4;
                totalRead += copied4;
                ++buffi;
                continue;
            }
            cbuf[cbufi++] = this.buffer[buffi++];
            ++totalRead;
        }
        if (buffi < bufferSize && (copied2 = this.copyToResult(this.buffer, buffi, toBeOverFlowed = bufferSize - buffi, cbuf, cbufi, last)) != 0) {
            throw new TemplateInputException("Overflow was not correctly computed!");
        }
        if (overflowOverflow != null && (copied = this.copyToResult(overflowOverflow, 0, overflowOverflow.length, cbuf, cbufi, last)) != 0) {
            throw new TemplateInputException("Overflow-overflow was not correctly computed!");
        }
        if (readerLogger.isTraceEnabled()) {
            char[] result = new char[totalRead];
            System.arraycopy(cbuf, off, result, 0, totalRead);
            readerLogger.trace("[THYMELEAF][TEMPLATEPREPROCESSINGREADER][{}] RETURN {} Input was read and processed. Returning content: [[{}]]", new Object[]{TemplateEngine.threadIndex(), totalRead, new String(result)});
        }
        return totalRead;
    }

    public int read() throws IOException {
        char[] cbuf;
        int res;
        if (readerLogger.isTraceEnabled()) {
            readerLogger.trace("[THYMELEAF][TEMPLATEPREPROCESSINGREADER][{}] CALLING read(). Will be delegated to read(char[], 0, 1).", new Object[]{TemplateEngine.threadIndex()});
        }
        if ((res = this.read(cbuf = new char[1], 0, 1)) <= 0) {
            return res;
        }
        return cbuf[0];
    }

    public int read(CharBuffer target) throws IOException {
        int read;
        if (readerLogger.isTraceEnabled()) {
            readerLogger.trace("[THYMELEAF][TEMPLATEPREPROCESSINGREADER][{}] CALLING read(CharBuffer). Will be delegated as several calls to read(char[], 0, 1024).", new Object[]{TemplateEngine.threadIndex()});
        }
        char[] cbuf = new char[1024];
        int totalRead = -1;
        while ((read = this.read(cbuf, 0, cbuf.length)) != -1) {
            target.put(cbuf, 0, read);
            if (totalRead == -1) {
                totalRead = 0;
            }
            totalRead += read;
        }
        return totalRead;
    }

    public int read(char[] cbuf) throws IOException {
        if (readerLogger.isTraceEnabled()) {
            readerLogger.trace("[THYMELEAF][TEMPLATEPREPROCESSINGREADER][{}] CALLING read(char[] cbuf). Will be delegated to read(cbuf, 0, cbuf.length).", new Object[]{TemplateEngine.threadIndex()});
        }
        return this.read(cbuf, 0, cbuf.length);
    }

    public long skip(long n) throws IOException {
        throw new IOException("Skip not supported in reader");
    }

    public boolean ready() throws IOException {
        if (this.bufferedReader.ready()) {
            return true;
        }
        return this.overflowIndex > 0;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("Mark not supported in reader");
    }

    public void reset() throws IOException {
        throw new IOException("Reset not supported in reader");
    }

    public void close() throws IOException {
        this.bufferedReader.close();
    }

    private int copyToResult(char[] fragment, int fragmentOff, int fragmentLen, char[] cbuf, int cbufi, int last) {
        if (cbufi + fragmentLen < last) {
            System.arraycopy(fragment, fragmentOff, cbuf, cbufi, fragmentLen);
            if (fragment == this.overflow) {
                this.overflowIndex = 0;
            }
            return fragmentLen;
        }
        int toBeCopied = last - cbufi;
        int toBeOverflowed = fragmentLen - toBeCopied;
        if (toBeCopied > 0) {
            System.arraycopy(fragment, fragmentOff, cbuf, cbufi, toBeCopied);
        }
        if (fragment != this.overflow) {
            System.arraycopy(fragment, fragmentOff + toBeCopied, this.overflow, this.overflowIndex, toBeOverflowed);
            this.overflowIndex += toBeOverflowed;
        } else {
            System.arraycopy(fragment, fragmentOff + toBeCopied, this.overflow, 0, toBeOverflowed);
            this.overflowIndex = toBeOverflowed;
        }
        return toBeCopied;
    }

    private static int match(int[] fragment, int fragmentOff, int fragmentLen, char[] buffer, int buffi, int bufferLast) {
        char f0Lower = LOWER_CHARS[fragment[fragmentOff]];
        char f0Upper = UPPER_CHARS[fragment[fragmentOff]];
        if (f0Lower != '\u0359' && f0Lower != '\u0360' && f0Lower != buffer[buffi] && f0Upper != buffer[buffi]) {
            return -1;
        }
        int fragmentLast = fragmentOff + fragmentLen;
        int buffj = buffi;
        int fragmenti = fragmentOff;
        while (buffj < bufferLast && fragmenti < fragmentLast) {
            int fragmentIndex = fragment[fragmenti];
            char fLower = LOWER_CHARS[fragmentIndex];
            if (fLower == '\u0359') {
                if (buffer[buffj] != ' ' && buffer[buffj] != '\t') {
                    if (buffj > buffi && (buffer[buffj - 1] == ' ' || buffer[buffj - 1] == '\t')) {
                        ++fragmenti;
                        continue;
                    }
                    return -1;
                }
                ++buffj;
                continue;
            }
            if (fLower == '\u0358') {
                if (buffer[buffj] != ' ' && buffer[buffj] != '\t') {
                    ++fragmenti;
                    continue;
                }
                ++buffj;
                continue;
            }
            if (fLower == '\u0360') {
                boolean isHash;
                char c = buffer[buffj];
                boolean isUpper = c >= 'A' && c <= 'Z';
                boolean isLower = c >= 'a' && c <= 'z';
                boolean isDigit = c >= '0' && c <= '9';
                boolean bl = isHash = c == '#';
                if (!isUpper && !isLower && !isDigit && !isHash || fragmenti + 1 < fragmentLast && UPPER_CHARS[fragment[fragmenti + 1]] == buffer[buffj] || LOWER_CHARS[fragment[fragmenti + 1]] == buffer[buffj]) {
                    ++fragmenti;
                    continue;
                }
                ++buffj;
                continue;
            }
            if (fLower == '\u0361') {
                if (fragmenti + 1 < fragmentLast && UPPER_CHARS[fragment[fragmenti + 1]] == buffer[buffj] || LOWER_CHARS[fragment[fragmenti + 1]] == buffer[buffj]) {
                    ++fragmenti;
                    continue;
                }
                ++buffj;
                continue;
            }
            char bufferChar = buffer[buffj];
            if (bufferChar != UPPER_CHARS[fragmentIndex] && bufferChar != fLower) {
                return -1;
            }
            ++buffj;
            ++fragmenti;
        }
        if (fragmenti == fragmentLast) {
            return buffj - buffi;
        }
        return 0;
    }

    private static char[] normalizeDocTypeClause(char[] buffer, int offset, int len) {
        try {
            boolean afterQuote = false;
            char[] result = new char[len];
            System.arraycopy(NORMALIZED_DOCTYPE_PREFIX, 0, result, 0, NORMALIZED_DOCTYPE_PREFIX.length);
            for (int i = offset + NORMALIZED_DOCTYPE_PREFIX.length; i < offset + len; ++i) {
                char c7;
                char c6;
                char c5;
                char c4;
                char c3;
                char c2;
                char c = buffer[i];
                if (c == '\"') {
                    afterQuote = true;
                    result[i - offset] = c;
                    continue;
                }
                if (!(afterQuote || c != 'P' && c != 'p')) {
                    c2 = buffer[i + 1];
                    if (c2 == 'U' || c2 == 'u') {
                        c3 = buffer[i + 2];
                        c4 = buffer[i + 3];
                        c5 = buffer[i + 4];
                        c6 = buffer[i + 5];
                        c7 = buffer[i + 6];
                        if (!(c3 != 'B' && c3 != 'b' || c4 != 'L' && c4 != 'l' || c5 != 'I' && c5 != 'i' || c6 != 'C' && c6 != 'c' || c7 != ' ' && c7 != '\t')) {
                            System.arraycopy(NORMALIZED_DOCTYPE_PUBLIC, 0, result, i - offset, NORMALIZED_DOCTYPE_PUBLIC.length);
                            i += NORMALIZED_DOCTYPE_PUBLIC.length - 1;
                            continue;
                        }
                    }
                    result[i - offset] = c;
                    continue;
                }
                if (!(afterQuote || c != 'S' && c != 's')) {
                    c2 = buffer[i + 1];
                    if (c2 == 'Y' || c2 == 'y') {
                        c3 = buffer[i + 2];
                        c4 = buffer[i + 3];
                        c5 = buffer[i + 4];
                        c6 = buffer[i + 5];
                        c7 = buffer[i + 6];
                        if (!(c3 != 'S' && c3 != 's' || c4 != 'T' && c4 != 't' || c5 != 'E' && c5 != 'e' || c6 != 'M' && c6 != 'm' || c7 != ' ' && c7 != '\t')) {
                            System.arraycopy(NORMALIZED_DOCTYPE_SYSTEM, 0, result, i - offset, NORMALIZED_DOCTYPE_SYSTEM.length);
                            i += NORMALIZED_DOCTYPE_SYSTEM.length - 1;
                            continue;
                        }
                    }
                    result[i - offset] = c;
                    continue;
                }
                result[i - offset] = c;
            }
            return result;
        }
        catch (Exception e) {
            throw new TemplateInputException("DOCTYPE clause has bad format: \"" + new String(buffer, offset, len) + "\"");
        }
    }

    public String getDocTypeClause() {
        return this.docTypeClause;
    }

    public static final String removeEntitySubstitutions(String text) {
        if (text == null) {
            return null;
        }
        int textLen = text.length();
        for (int i = 0; i < textLen; ++i) {
            if (text.charAt(i) != '\ufff8') continue;
            char[] textCharArray = text.toCharArray();
            for (int j = 0; j < textLen; ++j) {
                if (textCharArray[j] != '\ufff8') continue;
                textCharArray[j] = 38;
            }
            return new String(textCharArray);
        }
        return text;
    }

    public static final void removeEntitySubstitutions(char[] text, int off, int len) {
        if (text == null) {
            return;
        }
        int finalPos = off + len;
        for (int i = off; i < finalPos; ++i) {
            if (text[i] != '\ufff8') continue;
            text[i] = 38;
        }
    }
}

