/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.xmlsax;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.CDATASection;
import org.thymeleaf.dom.Comment;
import org.thymeleaf.dom.DocType;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.exceptions.ParserInitializationException;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.templateparser.EntityResolver;
import org.thymeleaf.templateparser.ErrorHandler;
import org.thymeleaf.templateparser.ITemplateParser;
import org.thymeleaf.templateparser.TemplatePreprocessingReader;
import org.thymeleaf.util.ArrayUtils;
import org.thymeleaf.util.DOMUtils;
import org.thymeleaf.util.ResourcePool;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNonValidatingSAXTemplateParser
implements ITemplateParser {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ResourcePool<SAXParser> pool;
    private boolean canResetParsers = true;

    protected AbstractNonValidatingSAXTemplateParser(int poolSize) {
        this.pool = this.createSaxParsers(poolSize, false);
    }

    protected ResourcePool<SAXParser> getPool() {
        return this.pool;
    }

    protected final ResourcePool<SAXParser> getNonValidatingPool() {
        return this.pool;
    }

    protected final ResourcePool<SAXParser> createSaxParsers(int poolSize, boolean validating) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(validating);
        return new ResourcePool<SAXParser>(new SAXTemplateParserFactory(factory), poolSize);
    }

    @Override
    public final Document parseTemplate(Configuration configuration, String documentName, Reader reader) {
        return this.parseTemplateUsingPool(configuration, documentName, reader, this.getPool());
    }

    private final Document parseTemplateUsingPool(Configuration configuration, String documentName, Reader reader, ResourcePool<SAXParser> poolToBeUsed) {
        SAXParser saxParser = poolToBeUsed.allocate();
        TemplatePreprocessingReader templateReader = reader instanceof TemplatePreprocessingReader ? (TemplatePreprocessingReader)reader : new TemplatePreprocessingReader(reader, 8192);
        try {
            Document document = AbstractNonValidatingSAXTemplateParser.doParse(configuration, documentName, templateReader, saxParser);
            if (this.canResetParsers) {
                try {
                    saxParser.reset();
                }
                catch (UnsupportedOperationException e) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("[THYMELEAF] The SAX Parser implementation being used (\"{}\") does not implement the \"reset\" operation. This will force Thymeleaf to re-create parser instances each time they are needed for parsing templates, which is more costly. Enabling template cache is recommended, and also using a parser library which implements \"reset\" such as xerces version 2.9.1 or newer.", (Object)saxParser.getClass().getName());
                    }
                    this.canResetParsers = false;
                }
            }
            Document e = document;
            return e;
        }
        catch (IOException e) {
            throw new TemplateInputException("Exception parsing document", e);
        }
        catch (TemplateProcessingException e) {
            throw e;
        }
        catch (SAXParseException e) {
            String message = String.format("Exception parsing document: template=\"%s\", line %d - column %d", documentName, e.getLineNumber(), e.getColumnNumber());
            throw new TemplateInputException(message, e);
        }
        catch (SAXException e) {
            throw new TemplateInputException("Exception parsing document", e);
        }
        finally {
            if (this.canResetParsers) {
                poolToBeUsed.release(saxParser);
            } else {
                poolToBeUsed.discardAndReplace(saxParser);
            }
        }
    }

    private static Document doParse(Configuration configuration, String documentName, TemplatePreprocessingReader reader, SAXParser saxParser) throws IOException, SAXException {
        InputSource inputSource = new InputSource(reader);
        XmlSAXHandler handler = new XmlSAXHandler(documentName, new EntityResolver(configuration), ErrorHandler.INSTANCE);
        saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        saxParser.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
        saxParser.parse(inputSource, (DefaultHandler)handler);
        String docTypeClause = reader.getDocTypeClause();
        String docTypeRootElementName = handler.getDocTypeRootElementName();
        String docTypePublicId = handler.getDocTypePublicId();
        String docTypeSystemId = handler.getDocTypeSystemId();
        DocType docType = docTypeRootElementName != null ? new DocType(docTypeRootElementName, docTypePublicId, docTypeSystemId, docTypeClause) : null;
        List<Node> rootNodes = handler.getRootNodes();
        String xmlVersion = handler.getXmlVersion();
        String xmlEncoding = handler.getXmlEncoding();
        boolean xmlStandalone = handler.isXmlStandalone();
        Document document = new Document(documentName, docType);
        if (xmlVersion != null) {
            document.setNodeProperty("XML_VERSION", xmlVersion);
        }
        if (xmlEncoding != null) {
            document.setNodeProperty("XML_ENCODING", xmlEncoding);
        }
        if (xmlStandalone) {
            document.setNodeProperty("XML_STANDALONE", Boolean.TRUE);
        }
        document.setChildren(rootNodes);
        return document;
    }

    @Override
    public final List<Node> parseFragment(Configuration configuration, String fragment) {
        String wrappedFragment = this.wrapFragment(fragment);
        Document document = this.parseTemplateUsingPool(configuration, null, new StringReader(wrappedFragment), this.getNonValidatingPool());
        return this.unwrapFragment(document);
    }

    protected abstract String wrapFragment(String var1);

    protected abstract List<Node> unwrapFragment(Document var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SAXTemplateParserFactory
    implements ResourcePool.IResourceFactory<SAXParser> {
        private final SAXParserFactory saxParserFactory;

        public SAXTemplateParserFactory(SAXParserFactory saxParserFactory) {
            this.saxParserFactory = saxParserFactory;
        }

        @Override
        public SAXParser createResource() {
            try {
                return this.saxParserFactory.newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new ParserInitializationException("Error creating SAX parser", e);
            }
            catch (SAXException e) {
                throw new ParserInitializationException("Error creating SAX parser", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XmlSAXHandler
    extends DefaultHandler2 {
        private final String documentName;
        private final Stack<NestableNode> elementStack;
        private char[] textBuffer;
        private int textBufferLen;
        private char[] cdataBuffer;
        private int cdataBufferLen;
        private final org.xml.sax.EntityResolver entityResolver;
        private final org.xml.sax.ErrorHandler errorHandler;
        private Locator locator = null;
        private String docTypeRootElementName = null;
        private String docTypePublicId = null;
        private String docTypeSystemId = null;
        private List<Node> rootNodes = null;
        private boolean cdataMode = false;
        private boolean dtdMode = false;
        private String xmlEncoding = null;
        private String xmlVersion = null;
        private boolean xmlStandalone = false;
        private boolean xmlDeclarationComputed = false;

        public XmlSAXHandler(String documentName, org.xml.sax.EntityResolver entityResolver, org.xml.sax.ErrorHandler errorHandler) {
            this.documentName = documentName;
            this.elementStack = new Stack();
            this.rootNodes = new ArrayList<Node>();
            this.textBuffer = new char[512];
            this.cdataBuffer = new char[512];
            this.entityResolver = entityResolver;
            this.errorHandler = errorHandler;
        }

        public String getDocTypeRootElementName() {
            return this.docTypeRootElementName;
        }

        public String getDocTypePublicId() {
            return this.docTypePublicId;
        }

        public String getDocTypeSystemId() {
            return this.docTypeSystemId;
        }

        public List<Node> getRootNodes() {
            return this.rootNodes;
        }

        public String getXmlEncoding() {
            return this.xmlEncoding;
        }

        public String getXmlVersion() {
            return this.xmlVersion;
        }

        public boolean isXmlStandalone() {
            return this.xmlStandalone;
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            this.flushBuffer();
        }

        @Override
        public void startCDATA() throws SAXException {
            super.startCDATA();
            this.flushBuffer();
            this.cdataMode = true;
        }

        @Override
        public void endCDATA() throws SAXException {
            super.endCDATA();
            this.cdataMode = false;
            if (this.cdataBufferLen > 0) {
                CDATASection cdata = new CDATASection(ArrayUtils.copyOf(this.cdataBuffer, this.cdataBufferLen), false);
                if (this.elementStack.isEmpty()) {
                    this.rootNodes.add(cdata);
                } else {
                    NestableNode parent = this.elementStack.peek();
                    parent.addChild(cdata);
                }
                this.cdataBufferLen = 0;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            TemplatePreprocessingReader.removeEntitySubstitutions(ch, start, length);
            if (this.cdataMode) {
                while (this.cdataBufferLen + length > this.cdataBuffer.length) {
                    this.cdataBuffer = ArrayUtils.copyOf(this.cdataBuffer, this.cdataBuffer.length * 2);
                }
                System.arraycopy(ch, start, this.cdataBuffer, this.cdataBufferLen, length);
                this.cdataBufferLen += length;
            } else {
                while (this.textBufferLen + length > this.textBuffer.length) {
                    this.textBuffer = ArrayUtils.copyOf(this.textBuffer, this.textBuffer.length * 2);
                }
                System.arraycopy(ch, start, this.textBuffer, this.textBufferLen, length);
                this.textBufferLen += length;
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.characters(ch, start, length);
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (!this.dtdMode) {
                Comment comment = new Comment(ArrayUtils.copyOfRange(ch, start, start + length));
                if (this.elementStack.isEmpty()) {
                    this.rootNodes.add(comment);
                } else {
                    NestableNode parent = this.elementStack.peek();
                    parent.addChild(comment);
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!this.xmlDeclarationComputed) {
                if (this.locator != null && this.locator instanceof Locator2) {
                    Locator2 loc = (Locator2)this.locator;
                    this.xmlVersion = loc.getXMLVersion();
                    this.xmlEncoding = loc.getEncoding();
                }
                this.xmlDeclarationComputed = true;
            }
            this.flushBuffer();
            Integer lineNumber = null;
            if (this.locator != null) {
                lineNumber = this.locator.getLineNumber();
            }
            Element element = new Element(qName, this.documentName, lineNumber);
            for (int i = 0; i < attributes.getLength(); ++i) {
                element.setAttribute(attributes.getQName(i), DOMUtils.unescapeXml(TemplatePreprocessingReader.removeEntitySubstitutions(attributes.getValue(i)), true));
            }
            this.elementStack.push(element);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.flushBuffer();
            NestableNode element = this.elementStack.pop();
            if (this.elementStack.isEmpty()) {
                this.rootNodes.add(element);
            } else {
                NestableNode parent = this.elementStack.peek();
                parent.addChild(element);
            }
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            super.startDTD(name, publicId, systemId);
            this.docTypeRootElementName = name;
            this.docTypePublicId = publicId;
            this.docTypeSystemId = systemId;
            this.dtdMode = true;
        }

        @Override
        public void endDTD() throws SAXException {
            super.endDTD();
            this.dtdMode = false;
        }

        private void flushBuffer() {
            if (this.textBufferLen > 0) {
                Text textNode = new Text(ArrayUtils.copyOf(this.textBuffer, this.textBufferLen), false);
                if (this.elementStack.isEmpty()) {
                    this.rootNodes.add(textNode);
                } else {
                    NestableNode parent = this.elementStack.peek();
                    parent.addChild(textNode);
                }
                this.textBufferLen = 0;
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.errorHandler.error(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.errorHandler.fatalError(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.errorHandler.warning(exception);
        }

        @Override
        public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
            return null;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            return this.entityResolver.resolveEntity(publicId, systemId);
        }

        @Override
        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
            return this.resolveEntity(publicId, systemId);
        }
    }
}

