/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.TemplateRepository;
import org.thymeleaf.context.Context;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.exceptions.TemplateOutputException;
import org.thymeleaf.messageresolver.StandardMessageResolver;
import org.thymeleaf.resourceresolver.ClassLoaderResourceResolver;
import org.thymeleaf.templatemode.StandardTemplateModeHandlers;
import org.thymeleaf.templateparser.ITemplateParser;
import org.thymeleaf.templateparser.html.LegacyHtml5TemplateParser;
import org.thymeleaf.templateparser.xmlsax.XhtmlAndHtml5NonValidatingSAXTemplateParser;
import org.thymeleaf.templateparser.xmlsax.XmlNonValidatingSAXTemplateParser;
import org.thymeleaf.templateresolver.AlwaysValidTemplateResolutionValidity;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolution;
import org.thymeleaf.templatewriter.AbstractGeneralTemplateWriter;
import org.thymeleaf.templatewriter.XhtmlHtml5TemplateWriter;
import org.thymeleaf.templatewriter.XmlTemplateWriter;
import org.thymeleaf.util.Validate;

public final class DOMUtils {
    private static final char[] AMP = "&amp;".toCharArray();
    private static final char[] LT = "&lt;".toCharArray();
    private static final char[] GT = "&gt;".toCharArray();
    private static final char[] QUOT = "&quot;".toCharArray();
    private static final char[] APOS = "&#39;".toCharArray();

    public static NestableNode extractFragmentByAttributeValue(Node root, String elementName, String attributeName, String attributeValue) {
        Validate.notNull(root, "Root cannot be null");
        Validate.notNull(attributeName, "Attribute name cannot be null");
        Validate.notNull(attributeValue, "Attribute value cannot be null");
        return DOMUtils.exploreNodeForExtractingFragment(root, Node.normalizeName(elementName), Node.normalizeName(attributeName), attributeValue);
    }

    private static NestableNode exploreNodeForExtractingFragment(Node node, String normalizedElementName, String normalizedAttributeName, String attributeValue) {
        if (node instanceof NestableNode) {
            String elementAttrValue;
            Element element;
            NestableNode nestableNode = (NestableNode)node;
            if (nestableNode instanceof Element && (element = (Element)nestableNode).hasNormalizedAttribute(normalizedAttributeName) && (normalizedElementName == null || normalizedElementName.equals(element.getNormalizedName())) && (elementAttrValue = element.getAttributeValue(normalizedAttributeName)) != null && elementAttrValue.trim().equals(attributeValue)) {
                return nestableNode;
            }
            List<Node> children = nestableNode.getChildren();
            for (Node child : children) {
                NestableNode childResult = DOMUtils.exploreNodeForExtractingFragment(child, normalizedElementName, normalizedAttributeName, attributeValue);
                if (childResult == null) continue;
                return childResult;
            }
        }
        return null;
    }

    public static char[] escapeXml(char[] ch, boolean escapeQuotes) throws IOException {
        if (ch == null) {
            return null;
        }
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (c != '&' && c != '<' && c != '>' && (!escapeQuotes || c != '\'' && c != '\"')) continue;
            CharArrayWriter writer = new CharArrayWriter();
            DOMUtils.writeXmlEscaped(ch, (Writer)writer, escapeQuotes);
            return writer.toCharArray();
        }
        return ch;
    }

    public static String escapeXml(String str, boolean escapeQuotes) throws IOException {
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (c != '&' && c != '<' && c != '>' && (!escapeQuotes || c != '\'' && c != '\"')) continue;
            CharArrayWriter writer = new CharArrayWriter();
            DOMUtils.writeXmlEscaped(str, (Writer)writer, escapeQuotes);
            return writer.toString();
        }
        return str;
    }

    public static void writeXmlEscaped(String buffer, Writer writer, boolean escapeQuotes) throws IOException {
        if (buffer == null) {
            return;
        }
        DOMUtils.writeXmlEscaped(buffer.toCharArray(), writer, escapeQuotes);
    }

    public static void writeXmlEscaped(char[] buffer, Writer writer, boolean escapeQuotes) throws IOException {
        if (buffer == null || buffer.length == 0) {
            return;
        }
        int off = 0;
        int len = 0;
        for (int i = 0; i < buffer.length; ++i) {
            char c = buffer[i];
            if (c == '&') {
                if (len > 0) {
                    writer.write(buffer, off, len);
                }
                if (DOMUtils.isEntityStart(buffer, i)) {
                    writer.write(38);
                } else {
                    writer.write(AMP);
                }
                off = i + 1;
                len = 0;
                continue;
            }
            if (c == '<') {
                if (len > 0) {
                    writer.write(buffer, off, len);
                }
                writer.write(LT);
                off = i + 1;
                len = 0;
                continue;
            }
            if (c == '>') {
                if (len > 0) {
                    writer.write(buffer, off, len);
                }
                writer.write(GT);
                off = i + 1;
                len = 0;
                continue;
            }
            if (escapeQuotes && c == '\"') {
                if (len > 0) {
                    writer.write(buffer, off, len);
                }
                writer.write(QUOT);
                off = i + 1;
                len = 0;
                continue;
            }
            if (escapeQuotes && c == '\'') {
                if (len > 0) {
                    writer.write(buffer, off, len);
                }
                writer.write(APOS);
                off = i + 1;
                len = 0;
                continue;
            }
            ++len;
        }
        if (len > 0) {
            writer.write(buffer, off, len);
        }
    }

    private static boolean isEntityStart(char[] buffer, int position) {
        for (int i = position + 1; i < buffer.length; ++i) {
            char c = buffer[i];
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == ';')) {
                return false;
            }
            if (c != ';') continue;
            return true;
        }
        return false;
    }

    public static String unescapeXml(String str, boolean unescapeQuotes) {
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        boolean existsAmpersand = false;
        for (int i = 0; i < strLen; ++i) {
            if (str.charAt(i) != '&') continue;
            existsAmpersand = true;
            break;
        }
        if (!existsAmpersand) {
            return str;
        }
        int off = 0;
        int len = 0;
        int entityStart = -1;
        int entityLen = 0;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (c == '&') {
                if (entityLen > 0) {
                    builder.append(str.substring(entityStart, entityStart + entityLen));
                } else if (len > 0) {
                    builder.append(str.substring(off, off + len));
                }
                entityStart = i;
                entityLen = 1;
                off = -1;
                len = 0;
                continue;
            }
            if (c == ';' && entityStart != -1) {
                builder.append(DOMUtils.unescapeXmlEntity(str, entityStart, entityLen + 1, unescapeQuotes));
                entityStart = -1;
                entityLen = 0;
                off = i + 1;
                len = 0;
                continue;
            }
            if (entityStart != -1) {
                ++entityLen;
                continue;
            }
            ++len;
        }
        if (entityLen > 0) {
            builder.append(str, entityStart, entityStart + entityLen);
        } else if (len > 0) {
            builder.append(str.substring(off, off + len));
        }
        return builder.toString();
    }

    private static String unescapeXmlEntity(String str, int off, int len, boolean unescapeQuotes) {
        if (len < 4) {
            return str.substring(off, off + len);
        }
        char c1 = str.charAt(off + 1);
        char c2 = str.charAt(off + 2);
        if (len == 4 && c1 == 'l' && c2 == 't') {
            return "<";
        }
        if (len == 4 && c1 == 'g' && c2 == 't') {
            return ">";
        }
        if (len == 5 && c1 == 'a' && c2 == 'm' && str.charAt(off + 3) == 'p') {
            return "&";
        }
        if (len == 6 && unescapeQuotes && c1 == 'q' && c2 == 'u' && str.charAt(off + 3) == 'o' && str.charAt(off + 4) == 't') {
            return "\"";
        }
        if (len == 6 && unescapeQuotes && c1 == 'a' && c2 == 'p' && str.charAt(off + 3) == 'o' && str.charAt(off + 4) == 's') {
            return "'";
        }
        if (len == 5 && c1 == '#') {
            char c3 = str.charAt(off + 3);
            if (c2 == '6' && c3 == '0') {
                return "<";
            }
            if (c2 == '6' && c3 == '2') {
                return ">";
            }
            if (c2 == '3' && c3 == '8') {
                return "&";
            }
            if (unescapeQuotes && c2 == '3' && c3 == '4') {
                return "\"";
            }
            if (unescapeQuotes && c2 == '3' && c3 == '9') {
                return "'";
            }
        }
        return str.substring(off, off + len);
    }

    public static String getXmlFor(Node node) {
        return DOMUtils.getOutputFor(node, new XmlTemplateWriter(), "XML");
    }

    @Deprecated
    public static String getXhtmlHtml5For(Node node) {
        return DOMUtils.getOutputFor(node, new XhtmlHtml5TemplateWriter(), "XHTML");
    }

    public static String getXhtmlFor(Node node) {
        return DOMUtils.getOutputFor(node, new XhtmlHtml5TemplateWriter(), "XHTML");
    }

    public static String getHtml5For(Node node) {
        return DOMUtils.getOutputFor(node, new XhtmlHtml5TemplateWriter(), "HTML5");
    }

    public static String getOutputFor(Node node, AbstractGeneralTemplateWriter templateWriter, String templateMode) {
        Validate.notNull(node, "Node cannot be null");
        Validate.notNull(templateWriter, "Template writer cannot be null");
        Configuration configuration = new Configuration();
        configuration.addTemplateResolver(new ClassLoaderTemplateResolver());
        configuration.addMessageResolver(new StandardMessageResolver());
        configuration.setTemplateModeHandlers(StandardTemplateModeHandlers.ALL_TEMPLATE_MODE_HANDLERS);
        configuration.initialize();
        String templateName = "output";
        TemplateProcessingParameters templateProcessingParameters = new TemplateProcessingParameters(configuration, "output", new Context());
        TemplateResolution templateResolution = new TemplateResolution("output", "resource:output", new ClassLoaderResourceResolver(), "UTF-8", templateMode, new AlwaysValidTemplateResolutionValidity());
        TemplateRepository templateRepository = new TemplateRepository(configuration);
        Document document = new Document("output");
        document.addChild(node);
        Arguments arguments = new Arguments(templateProcessingParameters, templateResolution, templateRepository, document);
        return DOMUtils.getOutputFor(arguments, node, templateWriter);
    }

    public static String getOutputFor(Arguments arguments, Node node, AbstractGeneralTemplateWriter templateWriter) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(node, "Node cannot be null");
        Validate.notNull(templateWriter, "Template writer cannot be null");
        try {
            StringWriter writer = new StringWriter();
            templateWriter.writeNode(arguments, writer, node);
            return writer.toString();
        }
        catch (IOException e) {
            throw new TemplateOutputException("Exception during creation of output for node", e);
        }
    }

    public static Document getHtml5DOMFor(Reader source) {
        Validate.notNull(source, "Source cannot be null");
        return DOMUtils.getDOMFor(source, new XhtmlAndHtml5NonValidatingSAXTemplateParser(1));
    }

    public static Document getLegacyHTML5DOMFor(Reader source) {
        Validate.notNull(source, "Source cannot be null");
        return DOMUtils.getDOMFor(source, new LegacyHtml5TemplateParser("LEGACYHTML5", 1));
    }

    public static Document getXmlDOMFor(Reader source) {
        Validate.notNull(source, "Source cannot be null");
        return DOMUtils.getDOMFor(source, new XmlNonValidatingSAXTemplateParser(1));
    }

    public static Document getXhtmlDOMFor(Reader source) {
        Validate.notNull(source, "Source cannot be null");
        return DOMUtils.getDOMFor(source, new XhtmlAndHtml5NonValidatingSAXTemplateParser(1));
    }

    public static Document getDOMFor(Reader source, ITemplateParser parser) {
        Validate.notNull(source, "Source cannot be null");
        Validate.notNull(parser, "Template parser cannot be null");
        Configuration configuration = new Configuration();
        configuration.addTemplateResolver(new ClassLoaderTemplateResolver());
        configuration.addMessageResolver(new StandardMessageResolver());
        configuration.setTemplateModeHandlers(StandardTemplateModeHandlers.ALL_TEMPLATE_MODE_HANDLERS);
        configuration.initialize();
        return DOMUtils.getDOMFor(configuration, source, parser);
    }

    public static Document getDOMFor(Configuration configuration, Reader source, ITemplateParser parser) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(source, "Source cannot be null");
        Validate.notNull(parser, "Template parser cannot be null");
        try {
            Document document = parser.parseTemplate(configuration, "input", source);
            return document;
        }
        catch (Exception e) {
            throw new TemplateInputException("Exception during parsing of source", e);
        }
    }

    private DOMUtils() {
    }
}

