/*
 * Decompiled with CFR 0.152.
 */
package play.modules.thymeleaf.dialect;

import java.util.Collections;
import java.util.Map;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import ognl.ClassResolver;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.ObjectUtils;
import play.modules.thymeleaf.dialect.PlayClassResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayOgnlVariableExpressionEvaluator
implements IStandardVariableExpressionEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(PlayOgnlVariableExpressionEvaluator.class);
    public static final PlayOgnlVariableExpressionEvaluator INSTANCE = new PlayOgnlVariableExpressionEvaluator();
    private static final String OGNL_CACHE_PREFIX = "{ognl}";
    private static boolean booleanFixApplied = false;
    private PlayClassResolver classResolver = new PlayClassResolver();

    public void clearClassCache() {
        this.classResolver.clearClassCache();
    }

    public final Object evaluate(Configuration configuration, IProcessingContext processingContext, String expression, boolean useSelectionAsRoot) {
        try {
            ICacheManager cacheManager;
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] OGNL expression: evaluating expression \"{}\" on target", (Object)TemplateEngine.threadIndex(), (Object)expression);
            }
            Object expressionTree = null;
            ICache cache = null;
            if (configuration != null && (cacheManager = configuration.getCacheManager()) != null && (cache = cacheManager.getExpressionCache()) != null) {
                expressionTree = cache.get((Object)(OGNL_CACHE_PREFIX + expression));
            }
            if (expressionTree == null) {
                expressionTree = Ognl.parseExpression((String)expression);
                if (cache != null && null != expressionTree) {
                    cache.put((Object)(OGNL_CACHE_PREFIX + expression), expressionTree);
                }
            }
            Map contextVariables = processingContext.getBaseContextVariables();
            Map<String, Object> additionalContextVariables = this.computeAdditionalContextVariables(processingContext);
            if (additionalContextVariables != null && !additionalContextVariables.isEmpty()) {
                contextVariables.putAll(additionalContextVariables);
            }
            Object evaluationRoot = useSelectionAsRoot ? processingContext.getExpressionSelectionEvaluationRoot() : processingContext.getExpressionEvaluationRoot();
            OgnlContext context = new OgnlContext(contextVariables);
            context.setClassResolver((ClassResolver)this.classResolver);
            return Ognl.getValue((Object)expressionTree, (Map)context, (Object)evaluationRoot);
        }
        catch (OgnlException e) {
            throw new TemplateProcessingException("Exception evaluating OGNL expression: \"" + expression + "\"", (Throwable)e);
        }
    }

    protected Map<String, Object> computeAdditionalContextVariables(IProcessingContext processingContext) {
        return Collections.emptyMap();
    }

    protected PlayOgnlVariableExpressionEvaluator() {
        if (!booleanFixApplied && this.shouldApplyOgnlBooleanFix()) {
            PlayOgnlVariableExpressionEvaluator.applyOgnlBooleanFix();
            booleanFixApplied = true;
        }
    }

    public String toString() {
        return "OGNL";
    }

    protected boolean shouldApplyOgnlBooleanFix() {
        return true;
    }

    private static void applyOgnlBooleanFix() {
        try {
            ClassLoader classLoader = ClassLoaderUtils.getClassLoader(PlayOgnlVariableExpressionEvaluator.class);
            ClassPool pool = new ClassPool(true);
            pool.insertClassPath((ClassPath)new LoaderClassPath(classLoader));
            CtClass[] params = new CtClass[]{pool.get(Object.class.getName())};
            CtClass ognlClass = pool.get("ognl.OgnlOps");
            CtClass fixClass = pool.get(PlayOgnlVariableExpressionEvaluator.class.getName());
            CtMethod ognlMethod = ognlClass.getDeclaredMethod("booleanValue", params);
            CtMethod fixMethod = fixClass.getDeclaredMethod("fixBooleanValue", params);
            ognlMethod.setBody(fixMethod, null);
            ognlClass.toClass(classLoader, null);
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace("Thymeleaf was not able to apply a fix on OGNL's boolean evaluation that would have enabled OGNL to evaluate Strings as booleans (e.g. in \"th:if\") in exactly the same way as Thymeleaf itself or Spring EL ('false', 'off' and 'no' should be considered \"false\"). This did not stop the initialization process.", (Throwable)e);
            }
            logger.info("Thymeleaf was not able to apply a fix on OGNL's boolean evaluation that would have enabled OGNL to evaluate Strings as booleans (e.g. in \"th:if\") in exactly the same way as Thymeleaf itself or Spring EL ('false', 'off' and 'no' should be considered \"false\"). This did not stop the initialization process. Exception raised was " + e.getClass().getName() + ": " + e.getMessage() + " [Set the log to TRACE for the complete exception stack trace]");
        }
    }

    static boolean fixBooleanValue(Object value) {
        return ObjectUtils.evaluateAsBoolean((Object)value);
    }
}

