/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.util.Map;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.ProcessingContext;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TemplateProcessingParameters {
    private final Configuration configuration;
    private final String templateName;
    private final IProcessingContext processingContext;

    public TemplateProcessingParameters(Configuration configuration, String templateName, IContext context) {
        this(configuration, templateName, new ProcessingContext(context));
    }

    public TemplateProcessingParameters(Configuration configuration, String templateName, IProcessingContext context) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(templateName, "Template name cannot be null");
        Validate.notNull(context, "Context cannot be null");
        this.configuration = configuration;
        this.templateName = templateName;
        this.processingContext = context;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public IContext getContext() {
        return this.processingContext.getContext();
    }

    public IProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    public Map<String, Object> getExecutionAttributes() {
        return this.configuration.getExecutionAttributes();
    }

    public Object getExecutionAttribute(String attributeName) {
        return this.configuration.getExecutionAttributes().get(attributeName);
    }
}

