/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.Template;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.templatemode.ITemplateModeHandler;
import org.thymeleaf.templateparser.ITemplateParser;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolution;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TemplateRepository {
    private static final Logger logger = LoggerFactory.getLogger(TemplateRepository.class);
    private final ICache<String, Template> templateCache;
    private final ICache<String, List<Node>> fragmentCache;
    private final Map<String, ITemplateParser> parsersByTemplateMode;

    public TemplateRepository(Configuration configuration) {
        Validate.notNull(configuration, "Configuration object cannot be null");
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager == null) {
            this.templateCache = null;
            this.fragmentCache = null;
        } else {
            this.templateCache = cacheManager.getTemplateCache();
            this.fragmentCache = cacheManager.getFragmentCache();
        }
        this.parsersByTemplateMode = new HashMap<String, ITemplateParser>();
        for (ITemplateModeHandler handler : configuration.getTemplateModeHandlers()) {
            this.parsersByTemplateMode.put(handler.getTemplateModeName(), handler.getTemplateParser());
        }
    }

    public void clearTemplateCache() {
        if (this.templateCache != null) {
            this.templateCache.clear();
        }
    }

    public void clearTemplateCacheFor(String templateName) {
        if (this.templateCache != null) {
            this.templateCache.clearKey(templateName);
        }
    }

    public void clearFragmentCache() {
        if (this.fragmentCache != null) {
            this.fragmentCache.clear();
        }
    }

    public void clearFragmentCacheFor(String fragment) {
        if (this.fragmentCache != null) {
            this.fragmentCache.clearKey(fragment);
        }
    }

    public Template getTemplate(TemplateProcessingParameters templateProcessingParameters) {
        Template cached;
        Validate.notNull(templateProcessingParameters, "Template Processing Parameters cannot be null");
        String templateName = templateProcessingParameters.getTemplateName();
        if (this.templateCache != null && (cached = this.templateCache.get(templateName)) != null) {
            return cached.clone();
        }
        Configuration configuration = templateProcessingParameters.getConfiguration();
        Set<ITemplateResolver> templateResolvers = configuration.getTemplateResolvers();
        TemplateResolution templateResolution = null;
        InputStream templateInputStream = null;
        for (ITemplateResolver templateResolver : templateResolvers) {
            if (templateInputStream != null) continue;
            templateResolution = templateResolver.resolveTemplate(templateProcessingParameters);
            if (templateResolution != null) {
                String resourceName = templateResolution.getResourceName();
                IResourceResolver resourceResolver = templateResolution.getResourceResolver();
                if (logger.isTraceEnabled()) {
                    logger.trace("[THYMELEAF][{}] Trying to resolve template \"{}\" as resource \"{}\" with resource resolver \"{}\"", new Object[]{TemplateEngine.threadIndex(), templateName, resourceName, resourceResolver.getName()});
                }
                if ((templateInputStream = resourceResolver.getResourceAsStream(templateProcessingParameters, resourceName)) == null) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("[THYMELEAF][{}] Template \"{}\" could not be resolved as resource \"{}\" with resource resolver \"{}\"", new Object[]{TemplateEngine.threadIndex(), templateName, resourceName, resourceResolver.getName()});
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("[THYMELEAF][{}] Template \"{}\" was correctly resolved as resource \"{}\" in mode {} with resource resolver \"{}\"", new Object[]{TemplateEngine.threadIndex(), templateName, resourceName, templateResolution.getTemplateMode(), resourceResolver.getName()});
                continue;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("[THYMELEAF][{}] Skipping template resolver \"{}\" for template \"{}\"", new Object[]{TemplateEngine.threadIndex(), templateResolver.getName(), templateName});
        }
        if (templateResolution == null || templateInputStream == null) {
            throw new TemplateInputException("Error resolving template \"" + templateProcessingParameters.getTemplateName() + "\", " + "template might not exist or might not be accessible by " + "any of the configured Template Resolvers");
        }
        String templateMode = templateResolution.getTemplateMode();
        ITemplateParser templateParser = this.parsersByTemplateMode.get(templateMode);
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Starting parsing of template \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)templateName);
        }
        String characterEncoding = templateResolution.getCharacterEncoding();
        InputStreamReader reader = null;
        if (characterEncoding != null && !characterEncoding.trim().equals("")) {
            try {
                reader = new InputStreamReader(templateInputStream, characterEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new TemplateInputException("Exception parsing document", e);
            }
        } else {
            reader = new InputStreamReader(templateInputStream);
        }
        Document document = templateParser.parseTemplate(configuration, templateName, reader);
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Finished parsing of template \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)templateName);
        }
        document.precompute(configuration);
        Template template = new Template(templateName, templateResolution, document);
        if (this.templateCache != null && templateResolution.getValidity().isCacheable()) {
            this.templateCache.put(templateName, template);
            return template.clone();
        }
        return template;
    }

    public List<Node> getFragment(Arguments arguments, String fragment) {
        List<Node> fragmentNodes;
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(fragment, "Fragment cannot be null");
        String templateMode = arguments.getTemplateResolution().getTemplateMode();
        String cacheKey = TemplateRepository.computeFragmentCacheKey(templateMode, fragment);
        if (this.fragmentCache != null && (fragmentNodes = this.fragmentCache.get(cacheKey)) != null) {
            return TemplateRepository.cloneFragmentNodes(fragmentNodes);
        }
        Configuration configuration = arguments.getConfiguration();
        ITemplateParser templateParser = configuration.getTemplateModeHandler(templateMode).getTemplateParser();
        List<Node> fragmentNodes2 = templateParser.parseFragment(configuration, fragment);
        if (this.fragmentCache != null) {
            this.fragmentCache.put(cacheKey, fragmentNodes2);
            return TemplateRepository.cloneFragmentNodes(fragmentNodes2);
        }
        return fragmentNodes2;
    }

    private static String computeFragmentCacheKey(String templateMode, String fragment) {
        return "{" + templateMode + "}" + fragment;
    }

    private static List<Node> cloneFragmentNodes(List<Node> fragmentNodes) {
        if (fragmentNodes == null) {
            return null;
        }
        ArrayList<Node> clonedNodes = new ArrayList<Node>();
        for (Node fragmentNode : fragmentNodes) {
            clonedNodes.add(fragmentNode.cloneNode(null, false));
        }
        return clonedNodes;
    }
}

