/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.VariablesMap;
import org.thymeleaf.expression.ExpressionEvaluatorObjects;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProcessingContext
implements IProcessingContext {
    protected static final String EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME = "%%{SELECTION_TARGET}%%";
    private IContext context;
    private Object evaluationRoot;
    private Object selectionEvaluationRoot;
    private final HashMap<String, Object> localVariables;
    private final Map<String, Object> baseContextVariables;

    protected AbstractProcessingContext(IContext context) {
        this(context, null, null, false);
    }

    protected AbstractProcessingContext(IContext context, Map<String, Object> localVariables) {
        this(context, localVariables, null, false);
    }

    protected AbstractProcessingContext(IContext context, Map<String, Object> localVariables, Object selectionTarget, boolean selectionTargetSet) {
        Validate.notNull(context, "Context cannot be null");
        this.context = context;
        HashMap hashMap = localVariables != null ? new HashMap(localVariables) : (this.localVariables = selectionTarget != null ? new HashMap() : null);
        if (selectionTargetSet) {
            this.localVariables.put(EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME, selectionTarget);
        }
        this.evaluationRoot = this.createEvaluationRoot();
        this.selectionEvaluationRoot = this.createSelectedEvaluationRoot();
        this.baseContextVariables = this.computeBaseContextVariables();
    }

    private Object createEvaluationRoot() {
        VariablesMap<String, Object> newEvaluationRoot = new VariablesMap<String, Object>();
        newEvaluationRoot.putAll(this.context.getVariables());
        if (this.hasLocalVariables()) {
            newEvaluationRoot.putAll(this.localVariables);
        }
        return newEvaluationRoot;
    }

    private Object createSelectedEvaluationRoot() {
        if (this.hasSelectionTarget()) {
            return this.getSelectionTarget();
        }
        return this.evaluationRoot;
    }

    protected Map<String, Object> computeBaseContextVariables() {
        return ExpressionEvaluatorObjects.computeEvaluationObjects(this);
    }

    @Override
    public Map<String, Object> getBaseContextVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.putAll(this.baseContextVariables);
        return variables;
    }

    @Override
    public IContext getContext() {
        return this.context;
    }

    @Override
    public Object getExpressionEvaluationRoot() {
        return this.evaluationRoot;
    }

    @Override
    public Object getExpressionSelectionEvaluationRoot() {
        return this.selectionEvaluationRoot;
    }

    @Override
    public boolean hasSelectionTarget() {
        return this.hasLocalVariable(EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME) || this.getContext().getVariables().containsKey(EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME);
    }

    @Override
    public Object getSelectionTarget() {
        if (this.hasLocalVariable(EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME)) {
            return this.getLocalVariable(EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME);
        }
        if (this.getContext().getVariables().containsKey(EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME)) {
            return this.getContext().getVariables().get(EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME);
        }
        return null;
    }

    @Override
    public boolean hasLocalVariables() {
        return this.localVariables != null && this.localVariables.size() > 0;
    }

    @Override
    public boolean hasLocalVariable(String variableName) {
        if (this.localVariables == null) {
            return false;
        }
        return this.localVariables.containsKey(variableName);
    }

    @Override
    public Object getLocalVariable(String variableName) {
        if (this.localVariables == null) {
            return null;
        }
        return this.localVariables.get(variableName);
    }

    @Override
    public Map<String, Object> getLocalVariables() {
        if (this.localVariables != null) {
            return Collections.unmodifiableMap(this.localVariables);
        }
        return null;
    }

    @Deprecated
    public HashMap<String, Object> unsafeGetLocalVariables() {
        return this.localVariables;
    }

    protected Map<String, Object> mergeNewLocalVariables(Map<String, Object> newVariables) {
        if (newVariables == null || newVariables.isEmpty()) {
            return this.localVariables;
        }
        int localVariablesSize = this.localVariables != null ? this.localVariables.size() : 0;
        HashMap<String, Object> cloneLocalVariables = new HashMap<String, Object>(localVariablesSize + newVariables.size() + 1, 1.0f);
        if (this.localVariables != null) {
            cloneLocalVariables.putAll(this.localVariables);
        }
        cloneLocalVariables.putAll(newVariables);
        return cloneLocalVariables;
    }
}

