/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.thymeleaf.context.VariablesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebSessionVariablesMap
extends VariablesMap<String, Object> {
    private static final long serialVersionUID = 3866833203758601975L;
    private final HttpSession session;

    public WebSessionVariablesMap(HttpSession session) {
        super(1, 1.0f);
        this.session = session;
    }

    @Override
    public int size() {
        if (this.session == null) {
            return 0;
        }
        int size = 0;
        Enumeration attributeNames = this.session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            attributeNames.nextElement();
            ++size;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        if (this.session == null) {
            return true;
        }
        return !this.session.getAttributeNames().hasMoreElements();
    }

    @Override
    public Object get(Object key) {
        if (this.session == null) {
            return null;
        }
        return this.session.getAttribute((String)key);
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.session == null) {
            return false;
        }
        Enumeration attributeNames = this.session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            if (!(key == null ? attributeName == null : key.equals(attributeName))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object put(String key, Object value) {
        if (this.session == null) {
            throw new IllegalStateException("Cannot put attribute into session: no HTTP session exists!");
        }
        this.session.setAttribute(key, value);
        return value;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        if (this.session == null) {
            throw new IllegalStateException("Cannot put attributes into session: no HTTP session exists!");
        }
        for (Map.Entry<? extends String, ? extends Object> mEntry : m.entrySet()) {
            this.session.setAttribute(mEntry.getKey(), mEntry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        if (this.session == null) {
            throw new IllegalStateException("Cannot remove attribute from session: no HTTP session exists!");
        }
        Object value = this.session.getAttribute((String)key);
        this.session.removeAttribute((String)key);
        return value;
    }

    @Override
    public void clear() {
        if (this.session == null) {
            throw new IllegalStateException("Cannot remove attribute from session: no HTTP session exists!");
        }
        ArrayList attributeNamesList = new ArrayList();
        Enumeration attributeNames = this.session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            attributeNamesList.add(attributeNames.nextElement());
        }
        for (String attributeName : attributeNamesList) {
            this.session.removeAttribute(attributeName);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.session == null) {
            return false;
        }
        Enumeration attributeNames = this.session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            Object attributeValue = this.session.getAttribute(attributeName);
            if (!(value == null ? attributeValue == null : value.equals(attributeValue))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        return new WebSessionVariablesMap(this.session);
    }

    @Override
    public Set<String> keySet() {
        if (this.session == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> keySet = new LinkedHashSet<String>();
        Enumeration attributeNames = this.session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            keySet.add((String)attributeNames.nextElement());
        }
        return keySet;
    }

    @Override
    public Collection<Object> values() {
        if (this.session == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> values = new ArrayList<Object>();
        Enumeration attributeNames = this.session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            values.add(this.session.getAttribute(attributeName));
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return WebSessionVariablesMap.getAttributeMap(this.session).entrySet();
    }

    @Override
    public String toString() {
        return WebSessionVariablesMap.getAttributeMap(this.session).toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.session.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebSessionVariablesMap other = (WebSessionVariablesMap)obj;
        return !(this.session == null ? other.session != null : !this.session.equals(other.session));
    }

    private static Map<String, Object> getAttributeMap(HttpSession session) {
        if (session == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> attributeMap = new LinkedHashMap<String, Object>();
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            Object attributeValue = session.getAttribute(attributeName);
            attributeMap.put(attributeName, attributeValue);
        }
        return attributeMap;
    }
}

