/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.doctype.resolution;

import java.io.IOException;
import org.thymeleaf.doctype.DocTypeIdentifier;
import org.thymeleaf.doctype.resolution.IDocTypeResolutionEntry;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.Validate;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ClassLoaderDocTypeResolutionEntry
implements IDocTypeResolutionEntry {
    private final DocTypeIdentifier systemID;
    private final DocTypeIdentifier publicID;
    private final String resourceName;

    public ClassLoaderDocTypeResolutionEntry(DocTypeIdentifier publicID, DocTypeIdentifier systemID, String resourceName) {
        Validate.notNull(resourceName, "Resource name cannot be null");
        this.publicID = publicID;
        this.systemID = systemID;
        this.resourceName = resourceName;
    }

    public DocTypeIdentifier getSystemID() {
        return this.systemID;
    }

    public DocTypeIdentifier getPublicID() {
        return this.publicID;
    }

    public InputSource createInputSource() throws SAXException, IOException {
        return new InputSource(ClassLoaderUtils.getClassLoader(ClassLoaderDocTypeResolutionEntry.class).getResourceAsStream(this.resourceName));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.publicID == null ? 0 : this.publicID.hashCode());
        result = 31 * result + (this.resourceName == null ? 0 : this.resourceName.hashCode());
        result = 31 * result + (this.systemID == null ? 0 : this.systemID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassLoaderDocTypeResolutionEntry other = (ClassLoaderDocTypeResolutionEntry)obj;
        if (this.publicID == null ? other.publicID != null : !this.publicID.equals(other.publicID)) {
            return false;
        }
        if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
            return false;
        }
        return !(this.systemID == null ? other.systemID != null : !this.systemID.equals(other.systemID));
    }
}

