/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dom;

import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.DOMUtils;
import org.thymeleaf.util.Validate;

public abstract class AbstractTextNode
extends Node {
    private static final long serialVersionUID = -4406245492696671750L;
    char[] content;

    AbstractTextNode(String content, boolean escapeXml, String documentName, Integer lineNumber) {
        this(content == null ? null : content.toCharArray(), escapeXml, documentName, lineNumber);
    }

    AbstractTextNode(char[] content, boolean escapeXml, String documentName, Integer lineNumber) {
        super(documentName, lineNumber);
        Validate.notNull(content, "Content cannot be null");
        try {
            this.content = escapeXml ? DOMUtils.escapeXml(content, true) : content;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error creating text node for content \"" + new String(content) + "\"", e);
        }
    }

    public String getContent() {
        return new String(this.content);
    }

    public char[] unsafeGetContentCharArray() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content.toCharArray();
    }

    public void unsafeSetContent(char[] newContent) {
        this.content = newContent;
    }

    final void doAdditionalSkippableComputing(boolean skippable) {
    }

    final void doAdditionalPrecomputeNode(Configuration configuration) {
    }

    final void doAdditionalProcess(Arguments arguments, boolean processOnlyElementNodes) {
    }
}

