/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.thymeleaf.dom.AbstractTextNode;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DOMSelector
implements Serializable {
    private static final long serialVersionUID = -1680336779267140369L;
    private static final String selectorPatternStr = "(/{1,2})([^/\\s]*?)(?:\\[(.*?)\\](?:\\[(.*?)\\])?)?";
    private static final Pattern selectorPattern = Pattern.compile("(/{1,2})([^/\\s]*?)(?:\\[(.*?)\\](?:\\[(.*?)\\])?)?");
    private final String selectorSpec;
    private final boolean descendMoreThanOneLevel;
    private final String selectorName;
    private final boolean text;
    private HashMap<String, String> attributes = null;
    private Integer index = null;
    private final DOMSelector next;

    public DOMSelector(String selectorSpec) {
        int firstNonSlash;
        this.selectorSpec = selectorSpec;
        String selectorSpecStr = selectorSpec.trim().startsWith("/") ? selectorSpec.trim() : "/" + selectorSpec.trim();
        int selectorSpecStrLen = selectorSpecStr.length();
        for (firstNonSlash = 0; firstNonSlash < selectorSpecStrLen && selectorSpecStr.charAt(firstNonSlash) == '/'; ++firstNonSlash) {
        }
        if (firstNonSlash >= selectorSpecStrLen) {
            throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorSpec + "\": '/' should be followed by a selector name");
        }
        int selEnd = selectorSpecStr.substring(firstNonSlash).indexOf(47);
        if (selEnd != -1) {
            String tail = selectorSpecStr.substring(firstNonSlash).substring(selEnd);
            selectorSpecStr = selectorSpecStr.substring(0, firstNonSlash + selEnd);
            this.next = new DOMSelector(tail);
        } else {
            this.next = null;
        }
        Matcher matcher = selectorPattern.matcher(selectorSpecStr);
        if (!matcher.matches()) {
            throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorSpec + "\": selector does not match selector syntax: " + "(/|//)(selector)([@attrib=\"value\" (and @attrib2=\"value\")?])?([index])?");
        }
        String rootGroup = matcher.group(1);
        String selectorNameGroup = matcher.group(2);
        String index1Group = matcher.group(3);
        String index2Group = matcher.group(4);
        if (rootGroup == null) {
            throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorSpec + "\": selector does not match selector syntax: " + "(/|//)(selector)([@attrib=\"value\" (and @attrib2=\"value\")?])?([index])?");
        }
        if ("//".equals(rootGroup)) {
            this.descendMoreThanOneLevel = true;
        } else if ("/".equals(rootGroup)) {
            this.descendMoreThanOneLevel = false;
        } else {
            throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorSpec + "\": selector does not match selector syntax: " + "(/|//)(selector)([@attrib=\"value\" (and @attrib2=\"value\")?])?([index])?");
        }
        if (selectorNameGroup == null) {
            throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorSpec + "\": selector does not match selector syntax: " + "(/|//)(selector)([@attrib=\"value\" (and @attrib2=\"value\")?])?([index])?");
        }
        this.selectorName = Node.normalizeName(selectorNameGroup);
        this.text = this.selectorName.equals("text()");
        if (index1Group != null) {
            Integer ind = DOMSelector.parseIndex(index1Group);
            if (ind == null) {
                HashMap<String, String> attribs = DOMSelector.parseAttributes(selectorSpec, index1Group);
                if (attribs == null) {
                    throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorSpec + "\": selector does not match selector syntax: " + "(/|//)(selector)([@attrib=\"value\" (and @attrib2=\"value\")?])?([index])?");
                }
                this.attributes = attribs;
            } else {
                this.index = ind;
            }
            if (index2Group != null) {
                if (this.index != null) {
                    throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorSpec + "\": selector does not match selector syntax: " + "(/|//)(selector)([@attrib=\"value\" (and @attrib2=\"value\")?])?([index])?");
                }
                ind = DOMSelector.parseIndex(index1Group);
                if (ind == null) {
                    throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorSpec + "\": selector does not match selector syntax: " + "(/|//)(selector)([@attrib=\"value\" (and @attrib2=\"value\")?])?([index])?");
                }
                this.index = ind;
            }
            if (this.descendMoreThanOneLevel && this.index != null) {
                throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorSpec + "\": index cannot be specified on a \"descend any levels\" selector (//).");
            }
        }
    }

    private static Integer parseIndex(String indexGroup) {
        if ("last()".equals(indexGroup.toLowerCase())) {
            return -1;
        }
        try {
            return Integer.valueOf(indexGroup);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static HashMap<String, String> parseAttributes(String selectorSpec, String indexGroup) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        DOMSelector.parseAttributes(selectorSpec, attributes, indexGroup);
        return attributes;
    }

    private static void parseAttributes(String selectorSpec, HashMap<String, String> attributes, String indexGroup) {
        String att = null;
        int andPos = indexGroup.indexOf(" and ");
        if (andPos != -1) {
            att = indexGroup.substring(0, andPos);
            String tail = indexGroup.substring(andPos + 5);
            DOMSelector.parseAttributes(selectorSpec, attributes, tail);
        } else {
            att = indexGroup;
        }
        DOMSelector.parseAttribute(selectorSpec, attributes, att);
    }

    private static void parseAttribute(String selectorSpec, HashMap<String, String> attributes, String attributeSpec) {
        int eqPos = attributeSpec.indexOf("=");
        if (eqPos != -1) {
            String attName = attributeSpec.substring(0, eqPos).trim();
            String attValue = attributeSpec.substring(eqPos + 1).trim();
            if (!attName.startsWith("@")) {
                throw new TemplateProcessingException("Invalid syntax in DOM selector: \"" + selectorSpec + "\"");
            }
            if (!(attValue.startsWith("\"") && attValue.endsWith("\"") || attValue.startsWith("'") && attValue.endsWith("'"))) {
                throw new TemplateProcessingException("Invalid syntax in DOM selector: \"" + selectorSpec + "\"");
            }
            attributes.put(Node.normalizeName(attName.substring(1)), attValue.substring(1, attValue.length() - 1));
        } else {
            String attName = attributeSpec.trim();
            if (!attName.startsWith("@")) {
                throw new TemplateProcessingException("Invalid syntax in DOM selector: \"" + selectorSpec + "\"");
            }
            attributes.put(Node.normalizeName(attName.substring(1)), null);
        }
    }

    public List<Node> select(Node node) {
        Validate.notNull(node, "Node to be searched cannot be null");
        return this.select(Collections.singletonList(node));
    }

    public List<Node> select(List<Node> nodes) {
        Validate.notEmpty(nodes, "Nodes to be searched cannot be null or empty");
        ArrayList<Node> selected = new ArrayList<Node>();
        for (Node node : nodes) {
            this.doCheckNodeSelection(selected, node);
        }
        return selected;
    }

    private final boolean checkChildrenSelection(List<Node> selectedNodes, Node node) {
        if (node instanceof NestableNode) {
            ArrayList<ArrayList<Node>> selectedNodesForChildren = new ArrayList<ArrayList<Node>>();
            NestableNode nestableNode = (NestableNode)node;
            if (nestableNode.hasChildren()) {
                Iterator<Node> i$ = nestableNode.getChildren().iterator();
                while (i$.hasNext()) {
                    ArrayList<Node> childSelectedNodes = new ArrayList<Node>();
                    Node node2 = i$.next();
                    if (!this.doCheckNodeSelection(childSelectedNodes, node2)) continue;
                    selectedNodesForChildren.add(childSelectedNodes);
                }
            }
            if (selectedNodesForChildren.size() == 0) {
                return false;
            }
            if (this.index == null) {
                for (List list : selectedNodesForChildren) {
                    selectedNodes.addAll(list);
                }
                return true;
            }
            if (this.index == -1) {
                selectedNodes.addAll((Collection)selectedNodesForChildren.get(selectedNodesForChildren.size() - 1));
                return true;
            }
            if (this.index >= selectedNodesForChildren.size()) {
                return false;
            }
            selectedNodes.addAll((Collection)selectedNodesForChildren.get(this.index));
            return true;
        }
        return false;
    }

    private final boolean doCheckNodeSelection(List<Node> selectedNodes, Node node) {
        NestableNode nestableNode;
        if (!this.doCheckSpecificNodeSelection(node)) {
            NestableNode nestableNode2;
            if (this.descendMoreThanOneLevel && node instanceof NestableNode && (nestableNode2 = (NestableNode)node).hasChildren()) {
                return this.checkChildrenSelection(selectedNodes, node);
            }
            return false;
        }
        if (this.next == null) {
            selectedNodes.add(node);
            return true;
        }
        if (node instanceof NestableNode && (nestableNode = (NestableNode)node).hasChildren()) {
            return this.next.checkChildrenSelection(selectedNodes, node);
        }
        return false;
    }

    private final boolean doCheckSpecificNodeSelection(Node node) {
        if (this.text) {
            return node instanceof AbstractTextNode;
        }
        if (node instanceof Element) {
            Element element = (Element)node;
            String normalizedName = element.getNormalizedName();
            if (!normalizedName.equals(this.selectorName)) {
                return false;
            }
            if (this.attributes == null || this.attributes.size() == 0) {
                return true;
            }
            for (Map.Entry<String, String> attributeEntry : this.attributes.entrySet()) {
                String attributeValue;
                String selectedAttributeName = attributeEntry.getKey();
                String selectedAttributeValue = attributeEntry.getValue();
                if (!(selectedAttributeValue == null ? !element.hasNormalizedAttribute(selectedAttributeName) : (attributeValue = element.getAttributeValueFromNormalizedName(selectedAttributeName)) == null || !attributeValue.equals(selectedAttributeValue))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final String toString() {
        return this.selectorSpec;
    }
}

