/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.fragment;

import java.util.List;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.Node;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChainedFragmentSpec
implements IFragmentSpec {
    private final IFragmentSpec fragmentSpec1;
    private final IFragmentSpec fragmentSpec2;

    public ChainedFragmentSpec(IFragmentSpec fragmentSpec1, IFragmentSpec fragmentSpec2) {
        Validate.notNull(fragmentSpec1, "Fragment spec 1 cannot be null");
        Validate.notNull(fragmentSpec2, "Fragment spec 2 cannot be null");
        this.fragmentSpec1 = fragmentSpec1;
        this.fragmentSpec2 = fragmentSpec2;
    }

    @Override
    public final List<Node> extractFragment(Configuration configuration, List<Node> nodes) {
        List<Node> firstResult = this.fragmentSpec1.extractFragment(configuration, nodes);
        return this.fragmentSpec2.extractFragment(configuration, firstResult);
    }

    public String toString() {
        return "(FRAGMENT SPEC 1: " + this.fragmentSpec1 + " | FRAGMENT SPEC 2: " + this.fragmentSpec2 + ")";
    }
}

