/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.fragment;

import java.util.List;
import org.thymeleaf.Configuration;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.dom.DOMSelector;
import org.thymeleaf.dom.Node;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DOMSelectorFragmentSpec
implements IFragmentSpec {
    private static final String DOM_SELECTOR_EXPRESSION_PREFIX = "{dom_selector}";
    private final String selectorExpression;

    public DOMSelectorFragmentSpec(String selectorExpression) {
        Validate.notEmpty(selectorExpression, "DOM selector expression cannot be null or empty");
        this.selectorExpression = selectorExpression;
    }

    public String getSelectorExpression() {
        return this.selectorExpression;
    }

    @Override
    public final List<Node> extractFragment(Configuration configuration, List<Node> nodes) {
        List<Node> selectedNodes;
        DOMSelector selector = null;
        ICache<String, Object> expressionCache = null;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (expressionCache = cacheManager.getExpressionCache()) != null) {
            selector = (DOMSelector)expressionCache.get(DOM_SELECTOR_EXPRESSION_PREFIX + this.selectorExpression);
        }
        if (selector == null) {
            selector = new DOMSelector(this.selectorExpression);
            if (expressionCache != null) {
                expressionCache.put(DOM_SELECTOR_EXPRESSION_PREFIX + this.selectorExpression, selector);
            }
        }
        if ((selectedNodes = selector.select(nodes)) == null || selectedNodes.size() == 0) {
            return null;
        }
        return selectedNodes;
    }

    public String toString() {
        return "(DOMSELECTOR: " + this.selectorExpression + ")";
    }
}

