/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.fragment;

import java.util.List;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.Node;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.util.DOMUtils;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementAndAttributeNameFragmentSpec
implements IFragmentSpec {
    private final String elementName;
    private final String attributeName;
    private final String attributeValue;

    public ElementAndAttributeNameFragmentSpec(String elementName, String attributeName, String attributeValue) {
        Validate.isTrue(StringUtils.isEmpty(elementName) == false || StringUtils.isEmpty(attributeName) == false, "Either element name of attribute name must not be null or empty");
        if (!StringUtils.isEmpty(attributeName).booleanValue()) {
            Validate.notEmpty(attributeValue, "Fragment attribute value cannot be null or empty");
        }
        this.elementName = elementName;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    @Override
    public final List<Node> extractFragment(Configuration configuration, List<Node> nodes) {
        return DOMUtils.extractFragmentByElementAndAttributeValue(nodes, this.elementName, this.attributeName, this.attributeValue);
    }

    public String toString() {
        return "(ELEMENT: " + this.elementName + " | ATTRIBUTE: " + this.attributeName + "=\"" + this.attributeValue + "\")";
    }
}

