/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.fragment;

import java.util.List;
import org.thymeleaf.Configuration;
import org.thymeleaf.Template;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.TemplateRepository;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dom.Node;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FragmentAndTarget {
    private final String templateName;
    private final IFragmentSpec fragmentSpec;

    public FragmentAndTarget(String templateName, IFragmentSpec fragmentSpec) {
        Validate.notEmpty(templateName, "Template name cannot be null or empty");
        Validate.notNull(fragmentSpec, "Fragment spec cannot be null or empty");
        this.templateName = templateName;
        this.fragmentSpec = fragmentSpec;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public IFragmentSpec getFragmentSpec() {
        return this.fragmentSpec;
    }

    public final List<Node> extractFragment(Configuration configuration, IContext context, TemplateRepository templateRepository) {
        TemplateProcessingParameters fragmentTemplateProcessingParameters = new TemplateProcessingParameters(configuration, this.getTemplateName(), context);
        Template parsedFragmentTemplate = templateRepository.getTemplate(fragmentTemplateProcessingParameters);
        return this.fragmentSpec.extractFragment(configuration, parsedFragmentTemplate.getDocument().getChildren());
    }
}

