/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.standard.expression.AdditionSubtractionExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.util.ObjectUtils;

public final class AdditionExpression
extends AdditionSubtractionExpression {
    private static final long serialVersionUID = -971366486450425605L;
    private static final Logger logger = LoggerFactory.getLogger(AdditionExpression.class);

    public AdditionExpression(Expression left, Expression right) {
        super(left, right);
    }

    public String getStringRepresentation() {
        return this.getStringRepresentation("+");
    }

    static Object executeAddition(Configuration configuration, IProcessingContext processingContext, AdditionExpression expression, IStandardVariableExpressionEvaluator expressionEvaluator) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating addition expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        Object leftValue = Expression.execute(configuration, processingContext, expression.getLeft(), expressionEvaluator);
        Object rightValue = Expression.execute(configuration, processingContext, expression.getRight(), expressionEvaluator);
        if (leftValue == null) {
            leftValue = "null";
        }
        if (rightValue == null) {
            rightValue = "null";
        }
        BigDecimal leftNumberValue = ObjectUtils.evaluateAsNumber(leftValue);
        BigDecimal rightNumberValue = ObjectUtils.evaluateAsNumber(rightValue);
        if (leftNumberValue != null && rightNumberValue != null) {
            return leftNumberValue.add(rightNumberValue);
        }
        return new LiteralValue(LiteralValue.unwrap(leftValue).toString().concat(LiteralValue.unwrap(rightValue).toString()));
    }
}

