/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.GreaterLesserExpression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.util.ObjectUtils;

public final class LessOrEqualToExpression
extends GreaterLesserExpression {
    private static final long serialVersionUID = 7042174616566611488L;
    private static final Logger logger = LoggerFactory.getLogger(LessOrEqualToExpression.class);

    public LessOrEqualToExpression(Expression left, Expression right) {
        super(left, right);
    }

    public String getStringRepresentation() {
        return this.getStringRepresentation("<=");
    }

    static Object executeLessOrEqualTo(Configuration configuration, IProcessingContext processingContext, LessOrEqualToExpression expression, IStandardVariableExpressionEvaluator expressionEvaluator) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating LESS OR EQUAL TO expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        Object leftValue = Expression.execute(configuration, processingContext, expression.getLeft(), expressionEvaluator);
        Object rightValue = Expression.execute(configuration, processingContext, expression.getRight(), expressionEvaluator);
        if (leftValue == null || rightValue == null) {
            throw new TemplateProcessingException("Cannot execute LESS OR EQUAL TO comparison: operands are \"" + LiteralValue.unwrap(leftValue) + "\" and \"" + LiteralValue.unwrap(rightValue) + "\"");
        }
        leftValue = LiteralValue.unwrap(leftValue);
        rightValue = LiteralValue.unwrap(rightValue);
        Boolean result = null;
        BigDecimal leftNumberValue = ObjectUtils.evaluateAsNumber(leftValue);
        BigDecimal rightNumberValue = ObjectUtils.evaluateAsNumber(rightValue);
        if (leftNumberValue != null && rightNumberValue != null) {
            result = leftNumberValue.compareTo(rightNumberValue) != 1;
        } else if (leftValue != null && rightValue != null && leftValue.getClass().equals(rightValue.getClass()) && Comparable.class.isAssignableFrom(leftValue.getClass())) {
            result = ((Comparable)leftValue).compareTo(rightValue) <= 0;
        } else {
            throw new TemplateProcessingException("Cannot execute LESS OR EQUAL TO from Expression \"" + expression.getStringRepresentation() + "\". Left is \"" + leftValue + "\", right is \"" + rightValue + "\"");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating LESS OR EQUAL TO expression: \"{}\". Left is \"{}\", right is \"{}\". Result is \"{}\"", new Object[]{TemplateEngine.threadIndex(), expression.getStringRepresentation(), leftValue, rightValue, result});
        }
        return result;
    }
}

