/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.standard.expression.EqualsNotEqualsExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.util.ObjectUtils;

public final class NotEqualsExpression
extends EqualsNotEqualsExpression {
    private static final long serialVersionUID = 5831688164085171802L;
    private static final Logger logger = LoggerFactory.getLogger(NotEqualsExpression.class);

    public NotEqualsExpression(Expression left, Expression right) {
        super(left, right);
    }

    public String getStringRepresentation() {
        return this.getStringRepresentation("!=");
    }

    static Object executeNotEquals(Configuration configuration, IProcessingContext processingContext, NotEqualsExpression expression, IStandardVariableExpressionEvaluator expressionEvaluator) {
        Object leftValue = Expression.execute(configuration, processingContext, expression.getLeft(), expressionEvaluator);
        Object rightValue = Expression.execute(configuration, processingContext, expression.getRight(), expressionEvaluator);
        leftValue = LiteralValue.unwrap(leftValue);
        rightValue = LiteralValue.unwrap(rightValue);
        if (leftValue == null) {
            return rightValue != null;
        }
        Boolean result = null;
        BigDecimal leftNumberValue = ObjectUtils.evaluateAsNumber(leftValue);
        BigDecimal rightNumberValue = ObjectUtils.evaluateAsNumber(rightValue);
        result = leftNumberValue != null && rightNumberValue != null ? Boolean.valueOf(leftNumberValue.compareTo(rightNumberValue) != 0) : (leftValue != null && rightValue != null && leftValue.getClass().equals(rightValue.getClass()) && Comparable.class.isAssignableFrom(leftValue.getClass()) ? Boolean.valueOf(((Comparable)leftValue).compareTo(rightValue) != 0) : Boolean.valueOf(!leftValue.equals(rightValue)));
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating NOT EQUALS expression: \"{}\". Left is \"{}\", right is \"{}\". Result is \"{}\"", new Object[]{TemplateEngine.threadIndex(), expression.getStringRepresentation(), leftValue, rightValue, result});
        }
        return result;
    }
}

