/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.ArrayList;
import java.util.List;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.LinkExpression;
import org.thymeleaf.standard.expression.MessageExpression;
import org.thymeleaf.standard.expression.NumberLiteralExpression;
import org.thymeleaf.standard.expression.SelectionVariableExpression;
import org.thymeleaf.standard.expression.TextLiteralExpression;
import org.thymeleaf.standard.expression.VariableExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleExpression
extends Expression {
    private static final long serialVersionUID = 9145380484247069725L;
    static final char EXPRESSION_START_CHAR = '{';
    static final char EXPRESSION_END_CHAR = '}';

    protected SimpleExpression() {
    }

    static List<ExpressionParsingNode> decomposeSimpleExpressionsExceptNumberLiterals(String input) {
        return SimpleExpression.decomposeSimpleExpressions(input, false);
    }

    static List<ExpressionParsingNode> decomposeSimpleExpressions(String input) {
        return SimpleExpression.decomposeSimpleExpressions(input, true);
    }

    private static List<ExpressionParsingNode> decomposeSimpleExpressions(String input, boolean decomposeNumberLiterals) {
        if (input == null || input.trim().equals("")) {
            return null;
        }
        StringBuilder inputWithPlaceholders = new StringBuilder();
        StringBuilder fragment = new StringBuilder();
        ArrayList<ExpressionParsingNode> fragments = new ArrayList<ExpressionParsingNode>();
        int currentIndex = 1;
        int expLevel = 0;
        boolean inLiteral = false;
        boolean inNumber = false;
        int expSelectorChar = 0;
        int inputLen = input.length();
        for (int i = 0; i < inputLen; ++i) {
            SimpleExpression literalExpr;
            char c = input.charAt(i);
            if (!inLiteral && expLevel == 0 && inNumber && !Character.isDigit(c) && c != '.') {
                if (decomposeNumberLiterals) {
                    inNumber = false;
                    inputWithPlaceholders.append('\u00a7');
                    inputWithPlaceholders.append(String.valueOf(currentIndex++));
                    inputWithPlaceholders.append('\u00a7');
                    literalExpr = NumberLiteralExpression.parseNumberLiteral(fragment.toString());
                    if (literalExpr == null) {
                        return null;
                    }
                    fragments.add(new ExpressionParsingNode(literalExpr));
                    fragment = new StringBuilder();
                } else {
                    inNumber = false;
                }
            }
            if (expLevel == 0 && c == '\'') {
                if (i == 0 || !SimpleExpression.isEscaping(input, i)) {
                    boolean bl = inLiteral = !inLiteral;
                    if (inLiteral) {
                        inputWithPlaceholders.append((CharSequence)fragment);
                        fragment = new StringBuilder();
                        fragment.append(c);
                        continue;
                    }
                    inputWithPlaceholders.append('\u00a7');
                    inputWithPlaceholders.append(String.valueOf(currentIndex++));
                    inputWithPlaceholders.append('\u00a7');
                    fragment.append(c);
                    literalExpr = TextLiteralExpression.parseTextLiteral(fragment.toString());
                    if (literalExpr == null) {
                        return null;
                    }
                    fragments.add(new ExpressionParsingNode(literalExpr));
                    fragment = new StringBuilder();
                    continue;
                }
                fragment.append(c);
                continue;
            }
            if (!inLiteral && c == '{') {
                if (i > 0) {
                    if (expLevel == 0) {
                        char cPrev = input.charAt(i - 1);
                        if (cPrev == '$' || cPrev == '*' || cPrev == '#' || cPrev == '@') {
                            fragment.deleteCharAt(fragment.length() - 1);
                            inputWithPlaceholders.append((CharSequence)fragment);
                            fragment = new StringBuilder();
                            fragment.append(cPrev);
                            ++expLevel;
                            expSelectorChar = cPrev;
                        }
                    } else {
                        ++expLevel;
                    }
                }
                fragment.append(c);
                continue;
            }
            if (!inLiteral && c == '}') {
                if (expLevel > 0) {
                    if (--expLevel == 0) {
                        inputWithPlaceholders.append('\u00a7');
                        inputWithPlaceholders.append(String.valueOf(currentIndex++));
                        inputWithPlaceholders.append('\u00a7');
                        fragment.append(c);
                        SimpleExpression expr = null;
                        switch (expSelectorChar) {
                            case 36: {
                                expr = VariableExpression.parseVariable(fragment.toString());
                                break;
                            }
                            case 42: {
                                expr = SelectionVariableExpression.parseSelectionVariable(fragment.toString());
                                break;
                            }
                            case 35: {
                                expr = MessageExpression.parseMessage(fragment.toString());
                                break;
                            }
                            case 64: {
                                expr = LinkExpression.parseLink(fragment.toString());
                                break;
                            }
                            default: {
                                return null;
                            }
                        }
                        if (expr == null) {
                            return null;
                        }
                        fragments.add(new ExpressionParsingNode(expr));
                        expSelectorChar = 0;
                        fragment = new StringBuilder();
                        continue;
                    }
                    fragment.append(c);
                    continue;
                }
                fragment.append(c);
                continue;
            }
            if (decomposeNumberLiterals && !inLiteral && expLevel == 0 && Character.isDigit(c)) {
                if (!inNumber) {
                    inNumber = true;
                    inputWithPlaceholders.append((CharSequence)fragment);
                    fragment = new StringBuilder();
                }
                fragment.append(c);
                continue;
            }
            fragment.append(c);
        }
        if (inLiteral || expLevel > 0) {
            return null;
        }
        if (decomposeNumberLiterals && inNumber) {
            inputWithPlaceholders.append('\u00a7');
            inputWithPlaceholders.append(String.valueOf(currentIndex++));
            inputWithPlaceholders.append('\u00a7');
            NumberLiteralExpression literalExpr = NumberLiteralExpression.parseNumberLiteral(fragment.toString());
            if (literalExpr == null) {
                return null;
            }
            fragments.add(new ExpressionParsingNode(literalExpr));
            fragment = new StringBuilder();
        }
        inputWithPlaceholders.append((CharSequence)fragment);
        ArrayList<ExpressionParsingNode> result = new ArrayList<ExpressionParsingNode>();
        result.add(new ExpressionParsingNode(inputWithPlaceholders.toString()));
        result.addAll(fragments);
        return result;
    }

    static List<ExpressionParsingNode> addNumberLiteralDecomposition(List<ExpressionParsingNode> inputExprs, int inputIndex) {
        if (inputExprs == null || inputExprs.size() == 0 || inputIndex >= inputExprs.size()) {
            return null;
        }
        String input = inputExprs.get(inputIndex).getInput();
        StringBuilder inputWithPlaceholders = new StringBuilder();
        StringBuilder fragment = new StringBuilder();
        ArrayList<ExpressionParsingNode> fragments = new ArrayList<ExpressionParsingNode>();
        int currentIndex = inputExprs.size();
        boolean inNumber = false;
        boolean inExpression = false;
        int inputLen = input.length();
        for (int i = 0; i < inputLen; ++i) {
            char c = input.charAt(i);
            if (inNumber && !Character.isDigit(c) && c != '.') {
                inNumber = false;
                inputWithPlaceholders.append('\u00a7');
                inputWithPlaceholders.append(String.valueOf(currentIndex++));
                inputWithPlaceholders.append('\u00a7');
                NumberLiteralExpression literalExpr = NumberLiteralExpression.parseNumberLiteral(fragment.toString());
                if (literalExpr == null) {
                    return null;
                }
                fragments.add(new ExpressionParsingNode(literalExpr));
                fragment = new StringBuilder();
            }
            if (!inExpression && Character.isDigit(c)) {
                if (!inNumber) {
                    inNumber = true;
                    inputWithPlaceholders.append((CharSequence)fragment);
                    fragment = new StringBuilder();
                }
                fragment.append(c);
                continue;
            }
            if (c == '\u00a7') {
                inExpression = !inExpression;
                fragment.append(c);
                continue;
            }
            fragment.append(c);
        }
        if (inNumber) {
            inputWithPlaceholders.append('\u00a7');
            inputWithPlaceholders.append(String.valueOf(currentIndex++));
            inputWithPlaceholders.append('\u00a7');
            NumberLiteralExpression literalExpr = NumberLiteralExpression.parseNumberLiteral(fragment.toString());
            if (literalExpr == null) {
                return null;
            }
            fragments.add(new ExpressionParsingNode(literalExpr));
            fragment = new StringBuilder();
        }
        inputWithPlaceholders.append((CharSequence)fragment);
        List<ExpressionParsingNode> result = inputExprs;
        result.set(inputIndex, new ExpressionParsingNode(inputWithPlaceholders.toString()));
        result.addAll(fragments);
        return result;
    }

    private static boolean isEscaping(String input, int pos) {
        if (pos == 0 || input.charAt(pos - 1) != '\\') {
            return false;
        }
        boolean odd = false;
        for (int i = pos - 1; i >= 0; --i) {
            if (input.charAt(i) != '\\') {
                return odd;
            }
            odd = !odd;
        }
        return odd;
    }

    static Object executeSimple(Configuration configuration, IProcessingContext processingContext, SimpleExpression expression, IStandardVariableExpressionEvaluator expressionEvaluator) {
        if (expression instanceof VariableExpression) {
            return VariableExpression.executeVariable(configuration, processingContext, (VariableExpression)expression, expressionEvaluator);
        }
        if (expression instanceof MessageExpression) {
            return MessageExpression.executeMessage(configuration, processingContext, (MessageExpression)expression, expressionEvaluator);
        }
        if (expression instanceof TextLiteralExpression) {
            return TextLiteralExpression.executeTextLiteral(processingContext, (TextLiteralExpression)expression);
        }
        if (expression instanceof NumberLiteralExpression) {
            return NumberLiteralExpression.executeNumberLiteral(processingContext, (NumberLiteralExpression)expression);
        }
        if (expression instanceof LinkExpression) {
            return LinkExpression.executeLink(configuration, processingContext, (LinkExpression)expression, expressionEvaluator);
        }
        if (expression instanceof SelectionVariableExpression) {
            return SelectionVariableExpression.executeSelectionVariable(configuration, processingContext, (SelectionVariableExpression)expression, expressionEvaluator);
        }
        throw new TemplateProcessingException("Unrecognized simple expression: " + expression.getClass().getName());
    }
}

