/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.util.Validate;

public final class StandardExpressionExecutor {
    private final IStandardVariableExpressionEvaluator expressionEvaluator;

    StandardExpressionExecutor(IStandardVariableExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    public Object executeExpression(Arguments arguments, Expression expression) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(expression, "Expression cannot be null");
        Object result = Expression.execute(arguments.getConfiguration(), arguments, expression, this.expressionEvaluator);
        return LiteralValue.unwrap(result);
    }

    public Object executeExpression(Configuration configuration, IProcessingContext processingContext, Expression expression) {
        Validate.notNull(processingContext, "Expression evaluation context cannot be null");
        Validate.notNull(expression, "Expression cannot be null");
        Object result = Expression.execute(configuration, processingContext, expression, this.expressionEvaluator);
        return LiteralValue.unwrap(result);
    }

    public String toString() {
        return "Standard Expression Executor with expression evaluator: " + this.expressionEvaluator.toString();
    }
}

