/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.DeprecatedBridgeStandardExpressionEvaluator;
import org.thymeleaf.standard.expression.Each;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionSequence;
import org.thymeleaf.standard.expression.FragmentSelection;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.StandardExpressionExecutor;
import org.thymeleaf.standard.expression.StandardExpressionParser;

public final class StandardExpressionProcessor {
    public static final String STANDARD_EXPRESSION_EXECUTOR_ATTRIBUTE_NAME = "StandardExpressionExecutor";
    public static final String STANDARD_EXPRESSION_PARSER_ATTRIBUTE_NAME = "StandardExpressionParser";

    private StandardExpressionProcessor() {
    }

    public static Expression parseExpression(Arguments arguments, String input) {
        return StandardExpressionProcessor.getParserAttribute(arguments.getConfiguration()).parseExpression(arguments, input);
    }

    public static Expression parseExpression(Configuration configuration, IProcessingContext processingContext, String input) {
        return StandardExpressionProcessor.getParserAttribute(configuration).parseExpression(configuration, processingContext, input);
    }

    public static AssignationSequence parseAssignationSequence(Arguments arguments, String input, boolean allowParametersWithoutValue) {
        return StandardExpressionProcessor.getParserAttribute(arguments.getConfiguration()).parseAssignationSequence(arguments, input, allowParametersWithoutValue);
    }

    public static AssignationSequence parseAssignationSequence(Configuration configuration, IProcessingContext processingContext, String input, boolean allowParametersWithoutValue) {
        return StandardExpressionProcessor.getParserAttribute(configuration).parseAssignationSequence(configuration, processingContext, input, allowParametersWithoutValue);
    }

    public static ExpressionSequence parseExpressionSequence(Arguments arguments, String input) {
        return StandardExpressionProcessor.getParserAttribute(arguments.getConfiguration()).parseExpressionSequence(arguments, input);
    }

    public static ExpressionSequence parseExpressionSequence(Configuration configuration, IProcessingContext processingContext, String input) {
        return StandardExpressionProcessor.getParserAttribute(configuration).parseExpressionSequence(configuration, processingContext, input);
    }

    public static Each parseEach(Arguments arguments, String input) {
        return StandardExpressionProcessor.getParserAttribute(arguments.getConfiguration()).parseEach(arguments, input);
    }

    public static Each parseEach(Configuration configuration, IProcessingContext processingContext, String input) {
        return StandardExpressionProcessor.getParserAttribute(configuration).parseEach(configuration, processingContext, input);
    }

    public static FragmentSelection parseFragmentSelection(Arguments arguments, String input) {
        return StandardExpressionProcessor.getParserAttribute(arguments.getConfiguration()).parseFragmentSelection(arguments, input);
    }

    public static FragmentSelection parseFragmentSelection(Configuration configuration, IProcessingContext processingContext, String input) {
        return StandardExpressionProcessor.getParserAttribute(configuration).parseFragmentSelection(configuration, processingContext, input);
    }

    public static Object executeExpression(Arguments arguments, Expression expression) {
        return StandardExpressionProcessor.getExecutorAttribute(arguments.getConfiguration()).executeExpression(arguments, expression);
    }

    public static Object executeExpression(Configuration configuration, IProcessingContext processingContext, Expression expression) {
        return StandardExpressionProcessor.getExecutorAttribute(configuration).executeExpression(configuration, processingContext, expression);
    }

    public static Object processExpression(Arguments arguments, String input) {
        return StandardExpressionProcessor.executeExpression(arguments, StandardExpressionProcessor.parseExpression(arguments, input));
    }

    public static Object processExpression(Configuration configuration, IProcessingContext processingContext, String input) {
        return StandardExpressionProcessor.executeExpression(configuration, processingContext, StandardExpressionProcessor.parseExpression(configuration, processingContext, input));
    }

    private static StandardExpressionParser getParserAttribute(Configuration configuration) {
        Object parser = configuration.getExecutionAttributes().get(STANDARD_EXPRESSION_PARSER_ATTRIBUTE_NAME);
        if (parser == null || !(parser instanceof StandardExpressionParser)) {
            throw new TemplateProcessingException("No Standard Expression Parser has been registered as an execution argument. This is a requirement for using " + StandardExpressionProcessor.class.getSimpleName() + ", and might happen " + "if neither the Standard or the SpringStandard dialects have " + "been added to the Template Engine and none of the specified dialects registers an " + "attribute of type " + StandardExpressionParser.class.getName() + " with name " + "\"" + STANDARD_EXPRESSION_PARSER_ATTRIBUTE_NAME + "\"");
        }
        return (StandardExpressionParser)parser;
    }

    private static StandardExpressionExecutor getExecutorAttribute(Configuration configuration) {
        Object executor = configuration.getExecutionAttributes().get(STANDARD_EXPRESSION_EXECUTOR_ATTRIBUTE_NAME);
        if (executor == null || !(executor instanceof StandardExpressionExecutor)) {
            throw new TemplateProcessingException("No Standard Expression Executor has been registered as an execution argument. This is a requirement for using " + StandardExpressionProcessor.class.getSimpleName() + ", and might happen " + "if neither the Standard or the SpringStandard dialects have " + "been added to the Template Engine and none of the specified dialects registers an " + "attribute of type " + StandardExpressionExecutor.class.getName() + " with name " + "\"" + STANDARD_EXPRESSION_EXECUTOR_ATTRIBUTE_NAME + "\"");
        }
        return (StandardExpressionExecutor)executor;
    }

    @Deprecated
    public static StandardExpressionExecutor createStandardExpressionExecutor(IStandardExpressionEvaluator expressionEvaluator) {
        return new StandardExpressionExecutor(new DeprecatedBridgeStandardExpressionEvaluator(expressionEvaluator));
    }

    public static StandardExpressionExecutor createStandardExpressionExecutor(IStandardVariableExpressionEvaluator expressionEvaluator) {
        return new StandardExpressionExecutor(expressionEvaluator);
    }

    public static StandardExpressionParser createStandardExpressionParser(StandardExpressionExecutor executor) {
        return new StandardExpressionParser(executor);
    }
}

