/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor.attr;

import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.attr.AbstractLocalVariableDefinitionAttrProcessor;
import org.thymeleaf.standard.expression.Assignation;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStandardLocalVariableDefinitionAttrProcessor
extends AbstractLocalVariableDefinitionAttrProcessor {
    public AbstractStandardLocalVariableDefinitionAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    public AbstractStandardLocalVariableDefinitionAttrProcessor(String attributeName) {
        super(attributeName);
    }

    @Override
    protected final Map<String, Object> getNewLocalVariables(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        AssignationSequence assignations = StandardExpressionProcessor.parseAssignationSequence(arguments, attributeValue, false);
        if (assignations == null) {
            throw new TemplateProcessingException("Could not parse value as attribute assignations: \"" + attributeValue + "\"");
        }
        HashMap<String, Object> newLocalVariables = new HashMap<String, Object>(assignations.size() + 1, 1.0f);
        for (Assignation assignation : assignations) {
            String varName = assignation.getLeft().getValue();
            Expression expression = assignation.getRight();
            Object varValue = StandardExpressionProcessor.executeExpression(arguments, expression);
            newLocalVariables.put(varName, varValue);
        }
        return newLocalVariables;
    }
}

