/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.conversion;

import com.google.code.twig.conversion.PrimitiveConverter;
import com.google.code.twig.conversion.TypeConverter;
import com.google.code.twig.util.generic.GenericTypeReflector;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;

public class CollectionConverter
implements TypeConverter {
    private final TypeConverter delegate;

    public CollectionConverter(TypeConverter delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> T convert(Object source, Type type) {
        Object[] items = null;
        if (source instanceof Collection) {
            items = ((Collection)source).toArray();
        } else if (source instanceof Object[]) {
            items = (Object[])source;
        } else if (source.getClass().isArray()) {
            Class<?> componentType = source.getClass().getComponentType();
            Class<?> wrapper = PrimitiveConverter.getWrapperClassForPrimitive(componentType);
            int length = Array.getLength(source);
            items = (Object[])Array.newInstance(wrapper, length);
            for (int i = 0; i < length; ++i) {
                items[i] = Array.get(source, i);
            }
        }
        if (items == null) {
            return null;
        }
        Class<?> erased = GenericTypeReflector.erase(type);
        Type componentType = null;
        if (type instanceof GenericArrayType) {
            componentType = ((GenericArrayType)type).getGenericComponentType();
        } else if (erased.isArray()) {
            componentType = erased.getComponentType();
        } else if (Collection.class.isAssignableFrom(erased)) {
            Type exact = GenericTypeReflector.getExactSuperType(type, Collection.class);
            componentType = ((ParameterizedType)exact).getActualTypeArguments()[0];
        } else {
            throw new IllegalArgumentException("Unsupported collection type " + type);
        }
        ArrayList<Object> convertedItems = new ArrayList<Object>(items.length);
        for (Object item : items) {
            if (item != null && (item = this.delegate.convert(item, componentType)) == null) {
                throw new IllegalStateException("Could not convert list item " + item + " to " + componentType);
            }
            convertedItems.add(item);
        }
        return this.createCollectionInstance(erased, componentType, convertedItems);
    }

    protected <T> T createCollectionInstance(Class<?> erased, Type componentType, List<Object> convertedItems) {
        if (erased.isAssignableFrom(HashSet.class)) {
            HashSet<Object> result = new HashSet<Object>(convertedItems);
            return (T)result;
        }
        if (erased.isAssignableFrom(ArrayList.class)) {
            List<Object> result = convertedItems;
            return (T)result;
        }
        if (erased.isAssignableFrom(EnumSet.class)) {
            EnumSet<Enum> enumSet = EnumSet.noneOf((Class)componentType);
            for (Object item : convertedItems) {
                Enum e;
                if (!(item instanceof Enum)) {
                    Object tmp = Enum.valueOf(erased, (String)item);
                    e = tmp;
                } else {
                    e = (Enum)item;
                }
                enumSet.add(e);
            }
            return (T)enumSet;
        }
        if (erased.isArray()) {
            Class<?> arrayClass = GenericTypeReflector.erase(componentType);
            Object[] array = (Object[])Array.newInstance(arrayClass, convertedItems.size());
            Object[] result = convertedItems.toArray(array);
            return (T)result;
        }
        throw new IllegalArgumentException("Unsupported Collection type " + erased + ". Try declaring the interface instead of the concrete collection type.");
    }
}

