/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.Key;
import com.google.common.collect.MapMaker;
import com.vercer.util.reference.ObjectReference;
import com.vercer.util.reference.SimpleObjectReference;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class InstanceKeyCache {
    private Map<Key, Object> cacheByKey = new MapMaker().weakValues().concurrencyLevel(1).makeMap();
    private Map<Object, ObjectReference<Key>> cacheByValue = new MapMaker().weakKeys().concurrencyLevel(1).makeMap();

    public void cache(Key key, Object object) {
        this.cacheByKey.put(key, object);
        ActivatableKeyReference reference = new ActivatableKeyReference(key);
        this.cacheByValue.put(object, reference);
    }

    public void cacheKeyReferenceForInstance(Object object, ObjectReference<Key> keyReference) {
        if (this.cacheByValue.put(object, keyReference) != null) {
            throw new IllegalStateException("Object already existed: " + object);
        }
    }

    public void clear() {
        this.cacheByKey.clear();
        this.cacheByValue.clear();
    }

    public Key evictInstance(Object reference) {
        ObjectReference<Key> keyReference = this.cacheByValue.remove(reference);
        if (keyReference != null) {
            Key key = keyReference.get();
            this.cacheByKey.remove(key);
            return key;
        }
        return null;
    }

    public Object evictKey(Key key) {
        Object object = this.cacheByKey.remove(key);
        if (object == null) {
            throw new NoSuchElementException("Key " + key + " was not cached");
        }
        ObjectReference<Key> removed = this.cacheByValue.remove(object);
        assert (removed.get() == key);
        return object;
    }

    public <T> T getInstance(Key key) {
        return (T)this.cacheByKey.get(key);
    }

    public Key getKey(Object instance) {
        ObjectReference<Key> reference = this.cacheByValue.get(instance);
        if (reference != null) {
            return reference.get();
        }
        return null;
    }

    public ObjectReference<Key> getKeyReference(Object instance) {
        return this.cacheByValue.get(instance);
    }

    public Set<Key> getAllKeys() {
        return this.cacheByKey.keySet();
    }

    public Key getKeyAndActivate(Object instance) {
        ActivatableKeyReference reference = (ActivatableKeyReference)this.cacheByValue.get(instance);
        if (reference != null) {
            if (reference.activated) {
                throw new IllegalStateException("Instance was already activated");
            }
            reference.activated = true;
            return (Key)reference.get();
        }
        return null;
    }

    public boolean containsKey(Key key) {
        return this.cacheByKey.containsKey(key);
    }

    private static class ActivatableKeyReference
    extends SimpleObjectReference<Key> {
        private static final long serialVersionUID = 1L;
        private boolean activated;

        public ActivatableKeyReference(Key object) {
            super(object);
        }
    }
}

