/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.code.twig.PropertyTranslator;
import com.google.code.twig.conversion.TypeConverter;
import com.google.code.twig.standard.TranslatorObjectDatastore;
import com.google.code.twig.translator.DecoratingTranslator;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;

final class KeyFieldTranslator
extends DecoratingTranslator {
    private final TranslatorObjectDatastore datastore;
    private final TypeConverter converters;

    KeyFieldTranslator(TranslatorObjectDatastore datastore, PropertyTranslator chained, TypeConverter converters) {
        super(chained);
        this.datastore = datastore;
        this.converters = converters;
    }

    @Override
    public Set<Property> encode(Object instance, Path path, boolean indexed) {
        if (path.getParts().size() > 1) {
            throw new IllegalStateException("Key field cannot be in embedded instance with path " + path);
        }
        if (this.datastore.encodeKeySpec != null && instance != null) {
            if (instance instanceof Number) {
                long longValue = ((Number)instance).longValue();
                if (longValue != 0L) {
                    this.datastore.encodeKeySpec.setId(longValue);
                }
            } else {
                String keyName = (String)this.converters.convert(instance, (Type)((Object)String.class));
                this.datastore.encodeKeySpec.setName(keyName);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public Object decode(Set<Property> properties, Path prefix, Type type) {
        Object keyValue = this.datastore.decodeKey.getName();
        if (keyValue == null) {
            keyValue = this.datastore.decodeKey.getId();
        }
        return this.converters.convert(keyValue, type);
    }
}

