/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.Key;
import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.code.twig.PropertyTranslator;
import com.google.code.twig.standard.StandardCommonStoreCommand;
import com.google.code.twig.standard.StandardMultipleStoreCommand;
import com.google.code.twig.standard.StandardSingleStoreCommand;
import com.google.code.twig.standard.TranslatorObjectDatastore;
import com.google.code.twig.util.PropertySets;
import com.google.code.twig.util.SinglePropertySet;
import com.vercer.util.reference.ReadOnlyObjectReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

class RelationTranslator
implements PropertyTranslator {
    protected final TranslatorObjectDatastore datastore;
    private static final Logger logger = Logger.getLogger(RelationTranslator.class.getName());

    RelationTranslator(TranslatorObjectDatastore strategyObjectDatastore) {
        this.datastore = strategyObjectDatastore;
    }

    @Override
    public Object decode(Set<Property> properties, Path prefix, Type type) {
        if (properties.isEmpty() || properties.size() == 1 && PropertySets.firstValue(properties) == null) {
            return NULL_VALUE;
        }
        Object value = PropertySets.firstValue(properties);
        if (value instanceof Collection) {
            List keys = (List)value;
            return this.keysToInstances(keys);
        }
        return this.keyToInstance((Key)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object keysToInstances(List<Key> keys) {
        Map<Key, Object> keysToInstances;
        try {
            --this.datastore.activationDepth;
            keysToInstances = this.datastore.load().keys(keys).returnResultsNow();
        }
        finally {
            ++this.datastore.activationDepth;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator<Key> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Key key = iterator.next();
            Object instance = keysToInstances.get(key);
            if (instance != null) {
                result.add(instance);
                iterator.remove();
                continue;
            }
            logger.warning("No entity found for referenced key " + key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object keyToInstance(Key key) {
        Object result;
        try {
            --this.datastore.activationDepth;
            result = this.datastore.load().key(key).now();
        }
        finally {
            ++this.datastore.activationDepth;
        }
        if (result == null) {
            result = NULL_VALUE;
            logger.warning("No entity found for referenced key " + key);
        }
        return result;
    }

    @Override
    public Set<Property> encode(final Object instance, Path path, boolean indexed) {
        if (instance == null) {
            return Collections.emptySet();
        }
        ReadOnlyObjectReference<List<Object>> item = instance instanceof Collection ? new ReadOnlyObjectReference<List<Key>>(){

            @Override
            public List<Key> get() {
                List instances = (List)instance;
                Map instancesToKeys = RelationTranslator.this.instancesToKeys(instances, RelationTranslator.this.getParentKey());
                ArrayList<Key> keys = new ArrayList<Key>(instances.size());
                for (Object instance2 : instances) {
                    keys.add((Key)instancesToKeys.get(instance2));
                }
                return keys;
            }
        } : new ReadOnlyObjectReference<Key>(){

            @Override
            public Key get() {
                return RelationTranslator.this.instanceToKey(instance);
            }
        };
        return new SinglePropertySet(path, item, indexed);
    }

    protected Key instanceToKey(Object instance) {
        Key key = this.datastore.associatedKey(instance);
        if (key == null) {
            key = ((StandardSingleStoreCommand)((StandardCommonStoreCommand)((Object)this.datastore.store().instance(instance))).parentKey(this.getParentKey())).now();
        }
        return key;
    }

    private <T> Map<T, Key> instancesToKeys(Collection<T> instances, Key parentKey) {
        HashMap<T, Key> result = new HashMap<T, Key>(instances.size());
        ArrayList<T> missed = new ArrayList<T>(instances.size());
        for (T instance : instances) {
            Key key = this.datastore.associatedKey(instance);
            if (key == null) {
                missed.add(instance);
                continue;
            }
            result.put(instance, key);
        }
        if (!missed.isEmpty()) {
            result.putAll((Map<T, Key>)((StandardMultipleStoreCommand)((StandardCommonStoreCommand)((Object)this.datastore.store().instances(missed))).parentKey(parentKey)).now());
        }
        return result;
    }

    protected Key getParentKey() {
        return null;
    }
}

