/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.AsyncPreparedQuery;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.datastore.Transaction;
import com.google.code.twig.FindCommand;
import com.google.code.twig.standard.StandardBranchFindCommand;
import com.google.code.twig.standard.StandardRestrictedFindCommand;
import com.google.code.twig.standard.StandardRootFindCommand;
import com.google.code.twig.standard.TranslatorObjectDatastore;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

abstract class StandardCommonFindCommand<C extends FindCommand.CommonFindCommand<C>>
extends StandardRestrictedFindCommand<C>
implements FindCommand.CommonFindCommand<C>,
FindCommand.BranchFindCommand {
    protected List<StandardBranchFindCommand> children;
    protected List<Filter> filters;
    private FindCommand.MergeOperator operator;

    StandardCommonFindCommand(TranslatorObjectDatastore datastore) {
        super(datastore);
    }

    protected abstract Query newQuery();

    abstract StandardRootFindCommand<?> getRootCommand();

    @Override
    public C addFilter(String field, Query.FilterOperator operator, Object value) {
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>(2);
        }
        this.filters.add(new Filter(field, operator, value));
        return (C)this;
    }

    @Override
    public C addRangeFilter(String field, Object from, Object to) {
        this.addFilter(field, Query.FilterOperator.GREATER_THAN_OR_EQUAL, from);
        this.addFilter(field, Query.FilterOperator.LESS_THAN, to);
        return (C)this;
    }

    @Override
    public FindCommand.BranchFindCommand branch(FindCommand.MergeOperator operator) {
        if (this.operator != null) {
            throw new IllegalStateException("Can only branch a command once");
        }
        this.operator = operator;
        return this;
    }

    @Override
    public FindCommand.ChildFindCommand addChildCommand() {
        StandardBranchFindCommand child = new StandardBranchFindCommand(this);
        if (this.children == null) {
            this.children = new ArrayList<StandardBranchFindCommand>(2);
        }
        this.children.add(child);
        return child;
    }

    protected Collection<Query> queries() {
        if (this.children == null) {
            return Collections.singleton(this.newQuery());
        }
        ArrayList<Query> queries = new ArrayList<Query>(this.children.size() * 2);
        for (StandardBranchFindCommand child : this.children) {
            queries.addAll(child.queries());
        }
        return queries;
    }

    protected Collection<Query> getValidatedQueries() {
        Collection<Query> queries = this.queries();
        if (queries.iterator().next().isKeysOnly() && (this.entityRestriction != null || this.propertyRestriction != null)) {
            throw new IllegalStateException("Cannot set filters for a keysOnly query");
        }
        return queries;
    }

    void applyFilters(Query query) {
        if (this.filters != null) {
            for (Filter filter : this.filters) {
                query.addFilter(filter.field, filter.operator, filter.value);
            }
        }
    }

    Future<? extends Iterator<Entity>> futureEntityIterator() {
        Collection<Query> queries = this.queries();
        if (queries.size() == 1) {
            return this.futureSingleQueryEntities(queries.iterator().next());
        }
        assert (!queries.isEmpty());
        return this.futureMergedEntities(queries);
    }

    protected QueryResultIterator<Entity> nowSingleQueryEntities(Query query) {
        PreparedQuery prepared = this.datastore.servicePrepare(query);
        FetchOptions fetchOptions = this.getRootCommand().getFetchOptions();
        QueryResultIterator entities = fetchOptions == null ? prepared.asQueryResultIterator() : prepared.asQueryResultIterator(fetchOptions);
        return entities;
    }

    Future<QueryResultIterator<Entity>> futureSingleQueryEntities(Query query) {
        Transaction txn = this.datastore.getTransaction();
        AsyncPreparedQuery prepared = new AsyncPreparedQuery(query, txn);
        FetchOptions fetchOptions = this.getRootCommand().getFetchOptions();
        Future<QueryResultIterator<Entity>> futureEntities = fetchOptions == null ? prepared.asFutureQueryResultIterator() : prepared.asFutureQueryResultIterator(fetchOptions);
        return futureEntities;
    }

    protected Iterator<Entity> nowMultipleQueryEntities(Collection<Query> queries) {
        ArrayList<Iterator<Entity>> iterators = new ArrayList<Iterator<Entity>>(queries.size());
        for (Query query : queries) {
            PreparedQuery prepared = this.datastore.servicePrepare(query);
            FetchOptions fetchOptions = this.getRootCommand().getFetchOptions();
            Iterator<Object> entities = fetchOptions == null ? prepared.asIterator() : prepared.asIterator(fetchOptions);
            entities = this.applyEntityFilter(entities);
            iterators.add(entities);
        }
        Query query = queries.iterator().next();
        List sorts = query.getSortPredicates();
        Iterator<Entity> merged = this.mergeEntities(iterators, sorts);
        return merged;
    }

    <R> Future<Iterator<R>> futureMultiQueryInstanceIterator() {
        Collection<Query> queries = this.getValidatedQueries();
        return this.futureMultipleQueriesInstanceIterator(queries);
    }

    protected <R> Iterator<R> nowMultiQueryInstanceIterator() {
        try {
            Collection<Query> queries = this.getValidatedQueries();
            Iterator<Entity> entities = this.nowMultipleQueryEntities(queries);
            return this.entitiesToInstances(entities, this.propertyRestriction);
        }
        catch (Exception e) {
            throw (RuntimeException)e.getCause();
        }
    }

    private <R> Future<Iterator<R>> futureMultipleQueriesInstanceIterator(Collection<Query> queries) {
        final Future<Iterator<Entity>> futureMerged = this.futureMergedEntities(queries);
        return new Future<Iterator<R>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return futureMerged.cancel(mayInterruptIfRunning);
            }

            @Override
            public Iterator<R> get() throws InterruptedException, ExecutionException {
                return StandardCommonFindCommand.this.entitiesToInstances((Iterator)futureMerged.get(), StandardCommonFindCommand.this.propertyRestriction);
            }

            @Override
            public Iterator<R> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return StandardCommonFindCommand.this.entitiesToInstances((Iterator)futureMerged.get(timeout, unit), StandardCommonFindCommand.this.propertyRestriction);
            }

            @Override
            public boolean isCancelled() {
                return futureMerged.isCancelled();
            }

            @Override
            public boolean isDone() {
                return futureMerged.isDone();
            }
        };
    }

    private Future<Iterator<Entity>> futureMergedEntities(Collection<Query> queries) {
        List<Future<QueryResultIterator<Entity>>> futures = this.multiQueriesToFutureEntityIterators(queries);
        Query query = queries.iterator().next();
        List sorts = query.getSortPredicates();
        return this.futureEntityIteratorsToFutureMergedIterator(futures, sorts);
    }

    protected List<Future<QueryResultIterator<Entity>>> multiQueriesToFutureEntityIterators(Collection<Query> queries) {
        ArrayList<Future<QueryResultIterator<Entity>>> futures = new ArrayList<Future<QueryResultIterator<Entity>>>(queries.size());
        Transaction txn = this.datastore.getTransaction();
        for (Query query : queries) {
            AsyncPreparedQuery prepared = new AsyncPreparedQuery(query, txn);
            FetchOptions fetchOptions = this.getRootCommand().getFetchOptions();
            Future<QueryResultIterator<Entity>> futureEntities = fetchOptions == null ? prepared.asFutureQueryResultIterator() : prepared.asFutureQueryResultIterator(fetchOptions);
            futures.add(futureEntities);
        }
        return futures;
    }

    private Future<Iterator<Entity>> futureEntityIteratorsToFutureMergedIterator(final List<Future<QueryResultIterator<Entity>>> futures, final List<Query.SortPredicate> sorts) {
        return new Future<Iterator<Entity>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean success = true;
                for (Future future : futures) {
                    if (future.cancel(mayInterruptIfRunning)) continue;
                    success = false;
                }
                return success;
            }

            @Override
            public Iterator<Entity> get() throws InterruptedException, ExecutionException {
                return this.futureQueriesToEntities(futures);
            }

            @Override
            public Iterator<Entity> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.futureQueriesToEntities(futures);
            }

            private Iterator<Entity> futureQueriesToEntities(List<Future<QueryResultIterator<Entity>>> futures2) throws InterruptedException, ExecutionException {
                ArrayList<Iterator<Entity>> iterators = new ArrayList<Iterator<Entity>>(futures2.size());
                for (Future<QueryResultIterator<Entity>> future : futures2) {
                    Iterator<Entity> entities = (Iterator<Entity>)future.get();
                    entities = StandardCommonFindCommand.this.applyEntityFilter(entities);
                    iterators.add(entities);
                }
                return StandardCommonFindCommand.this.mergeEntities(iterators, sorts);
            }

            @Override
            public boolean isCancelled() {
                for (Future future : futures) {
                    if (future.isCancelled()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean isDone() {
                for (Future future : futures) {
                    if (future.isDone()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public class FilteredIterator<V>
    extends AbstractIterator<V> {
        private final Iterator<V> unfiltered;
        private final Predicate<V> predicate;

        public FilteredIterator(Iterator<V> unfiltered, Predicate<V> predicate) {
            this.unfiltered = unfiltered;
            this.predicate = predicate;
        }

        protected V computeNext() {
            while (this.unfiltered.hasNext()) {
                V next = this.unfiltered.next();
                if (!this.predicate.apply(next)) continue;
                return next;
            }
            return (V)this.endOfData();
        }
    }

    private static class Filter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String field;
        Query.FilterOperator operator;
        Object value;

        private Filter() {
        }

        public Filter(String field, Query.FilterOperator operator, Object value) {
            this.field = field;
            this.operator = operator;
            this.value = value;
        }
    }
}

