/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.code.twig.PropertyTranslator;
import com.google.code.twig.Restriction;
import com.google.code.twig.standard.StandardCommand;
import com.google.code.twig.standard.TranslatorObjectDatastore;
import com.google.code.twig.util.PropertyComparator;
import com.google.code.twig.util.PropertySets;
import com.google.code.twig.util.RestrictionToPredicateAdaptor;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class StandardDecodeCommand
extends StandardCommand {
    private static final PropertyComparator COMPARATOR = new PropertyComparator();

    StandardDecodeCommand(TranslatorObjectDatastore datastore) {
        super(datastore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T entityToInstance(Entity entity, Restriction<Property> predicate) {
        Object instance = this.datastore.keyCache.getInstance(entity.getKey());
        if (instance == null) {
            Key existingDecodeKey = this.datastore.decodeKey;
            this.datastore.decodeKey = entity.getKey();
            try {
                Type type = this.datastore.getConfiguration().kindToType(entity.getKind());
                TreeSet<Property> properties = PropertySets.create(entity.getProperties(), this.datastore.indexed);
                if (predicate != null) {
                    properties = Sets.filter(properties, new RestrictionToPredicateAdaptor<Property>(predicate));
                }
                TreeSet<Property> sorted = new TreeSet<Property>(COMPARATOR);
                sorted.addAll((Collection<Property>)properties);
                properties = sorted;
                instance = this.datastore.decoder(entity).decode(properties, Path.EMPTY_PATH, type);
                if (instance == null) {
                    throw new IllegalStateException("Could not translate entity " + entity);
                }
                if (instance == PropertyTranslator.NULL_VALUE) {
                    instance = null;
                }
            }
            finally {
                this.datastore.decodeKey = existingDecodeKey;
            }
        }
        return instance;
    }

    public final <T> Iterator<T> entitiesToInstances(final Iterator<Entity> entities, final Restriction<Property> filter) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return entities.hasNext();
            }

            @Override
            public T next() {
                return StandardDecodeCommand.this.entityToInstance((Entity)entities.next(), filter);
            }

            @Override
            public void remove() {
                entities.remove();
            }
        };
    }

    public <T> T keyToInstance(Key key, Restriction<Property> filter) {
        Object instance = this.datastore.keyCache.getInstance(key);
        if (instance == null) {
            Entity entity = this.keyToEntity(key);
            instance = entity == null ? null : this.entityToInstance(entity, filter);
        }
        return instance;
    }

    public final <T> Map<Key, T> keysToInstances(Collection<Key> keys, Restriction<Property> filter) {
        Map<Key, Entity> entities;
        HashMap<Key, T> result = new HashMap<Key, T>(keys.size());
        ArrayList<Key> missing = null;
        for (Key key : keys) {
            Object instance = this.datastore.keyCache.getInstance(key);
            if (instance != null) {
                result.put(key, instance);
                continue;
            }
            if (missing == null) {
                missing = new ArrayList<Key>(keys.size());
            }
            missing.add(key);
        }
        if (!missing.isEmpty() && !(entities = this.keysToEntities((Collection<Key>)missing)).isEmpty()) {
            Set<Map.Entry<Key, Entity>> entries = entities.entrySet();
            for (Map.Entry<Key, Entity> entry : entries) {
                T instance = this.entityToInstance(entry.getValue(), filter);
                result.put(entry.getKey(), instance);
            }
        }
        return result;
    }

    final Entity keyToEntity(Key key) {
        if (this.datastore.activationDepth >= 0) {
            try {
                return this.datastore.serviceGet(key);
            }
            catch (EntityNotFoundException e) {
                return null;
            }
        }
        return new Entity(key);
    }

    final Map<Key, Entity> keysToEntities(Collection<Key> keys) {
        if (this.datastore.activationDepth >= 0) {
            return this.datastore.serviceGet(keys);
        }
        HashMap<Key, Entity> result = new HashMap<Key, Entity>();
        for (Key key : keys) {
            result.put(key, new Entity(key));
        }
        return result;
    }
}

