/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Query;
import com.google.code.twig.standard.EntitySupplier;
import com.google.code.twig.standard.PrefetchParentIterator;
import com.google.code.twig.standard.StandardCommonFindCommand;
import com.google.code.twig.standard.StandardCommonParentsCommand;
import com.google.code.twig.standard.SuppliedPrefetchParentIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;

class StandardMultipleParentsCommand<P>
extends StandardCommonParentsCommand<P> {
    private final List<Iterator<Entity>> childEntityIterators;
    private final List<Query.SortPredicate> sorts;

    StandardMultipleParentsCommand(StandardCommonFindCommand<?> command, List<Iterator<Entity>> childEntityIterators, List<Query.SortPredicate> sorts) {
        super(command);
        this.childEntityIterators = childEntityIterators;
        this.sorts = sorts;
    }

    @Override
    public Iterator<P> now() {
        if (this.childCommand.getRootCommand().isKeysOnly()) {
            EntitySupplier supplier = new EntitySupplier(this.datastore, this.getFetchSize());
            ArrayList<Iterator<Entity>> parentEntityIterators = new ArrayList<Iterator<Entity>>(this.childEntityIterators.size());
            for (Iterator<Entity> childEntities : this.childEntityIterators) {
                childEntities = this.childCommand.applyEntityFilter(childEntities);
                Object parentEntities = new SuppliedPrefetchParentIterator(childEntities, supplier);
                parentEntities = this.applyEntityFilter((Iterator<Entity>)parentEntities);
                parentEntityIterators.add((Iterator<Entity>)parentEntities);
            }
            Iterator<Entity> mergedParentEntities = this.mergeEntities(parentEntityIterators, this.sorts);
            return this.entitiesToInstances(mergedParentEntities, this.propertyRestriction);
        }
        Iterator<Entity> mergedChildEntities = this.mergeEntities(this.childEntityIterators, this.sorts);
        mergedChildEntities = this.applyEntityFilter(mergedChildEntities);
        mergedChildEntities = this.childCommand.applyEntityFilter(mergedChildEntities);
        Object parentEntities = new PrefetchParentIterator(mergedChildEntities, this.datastore, this.getFetchSize());
        parentEntities = this.applyEntityFilter((Iterator<Entity>)parentEntities);
        return this.entitiesToInstances((Iterator<Entity>)parentEntities, this.propertyRestriction);
    }

    @Override
    public Future<Iterator<P>> later() {
        throw new UnsupportedOperationException("Not implemented yet. Depends on async bulk get.");
    }
}

