/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.Key;
import com.google.code.twig.LoadCommand;
import com.google.code.twig.standard.StandardCommonLoadCommand;
import com.google.code.twig.standard.StandardTypedLoadCommand;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Future;

public class StandardMultipleTypedLoadCommand<T, I>
extends StandardCommonLoadCommand<StandardMultipleTypedLoadCommand<T, I>>
implements LoadCommand.MultipleTypedLoadCommand<T, I, StandardMultipleTypedLoadCommand<T, I>> {
    private final Collection<? extends I> ids;

    StandardMultipleTypedLoadCommand(StandardTypedLoadCommand<T> command, Collection<? extends I> ids) {
        super(command);
        this.ids = ids;
    }

    @Override
    public Future<Map<I, T>> later() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Map<I, T> now() {
        Field keyField = this.datastore.keyField(this.command.type);
        String kind = this.datastore.getConfiguration().typeToKind(this.command.type);
        LinkedHashMap<I, Key> idsToKeys = new LinkedHashMap<I, Key>(this.ids.size());
        for (I id : this.ids) {
            idsToKeys.put(id, this.idToKey(id, keyField, kind));
        }
        final Map keysToInstances = this.keysToInstances(idsToKeys.values(), this.propertyRestriction);
        return Maps.transformValues(idsToKeys, (Function)new Function<Key, T>(){

            public T apply(Key key) {
                return keysToInstances.get(key);
            }
        });
    }
}

