/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.AsyncDatastoreHelper;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Query;
import com.google.code.twig.FindCommand;
import com.google.code.twig.Property;
import com.google.code.twig.Restriction;
import com.google.code.twig.standard.StandardDecodeCommand;
import com.google.code.twig.standard.TranslatorObjectDatastore;
import com.google.code.twig.util.RestrictionToPredicateAdaptor;
import com.google.code.twig.util.SortedMergeIterator;
import com.google.common.collect.Iterators;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

abstract class StandardRestrictedFindCommand<C extends FindCommand.RestrictedFindCommand<C>>
extends StandardDecodeCommand
implements FindCommand.RestrictedFindCommand<C> {
    Restriction<Entity> entityRestriction;
    Restriction<Property> propertyRestriction;

    StandardRestrictedFindCommand(TranslatorObjectDatastore datastore) {
        super(datastore);
    }

    @Override
    public C restrictEntities(Restriction<Entity> filter) {
        if (this.entityRestriction != null) {
            throw new IllegalStateException("Entity filter was already set");
        }
        this.entityRestriction = filter;
        return (C)this;
    }

    @Override
    public C restrictProperties(Restriction<Property> filter) {
        if (this.propertyRestriction != null) {
            throw new IllegalStateException("Property filter was already set");
        }
        this.propertyRestriction = filter;
        return (C)this;
    }

    Iterator<Entity> applyEntityFilter(Iterator<Entity> entities) {
        if (this.entityRestriction != null) {
            entities = Iterators.filter(entities, new RestrictionToPredicateAdaptor<Entity>(this.entityRestriction));
        }
        return entities;
    }

    Iterator<Entity> mergeEntities(List<Iterator<Entity>> iterators, List<Query.SortPredicate> sorts) {
        Object merged;
        if (sorts != null && !sorts.isEmpty()) {
            Comparator<Entity> comparator = AsyncDatastoreHelper.newEntityComparator(sorts);
            merged = new SortedMergeIterator<Entity>(comparator, iterators);
        } else {
            merged = Iterators.concat(iterators.iterator());
        }
        return merged;
    }
}

